/* kinoko-viewer.cc */
/* Created by Enomoto Sanshiro on 1 September 2001. */
/* Last updated by Enomoto Sanshiro on 1 September 2001. */


#include <iostream>
#include "MushArgumentList.hh"
#include "KinokoStandaloneComponent.hh"
#include "KinokoViewer.hh"

using namespace std;


int main(int argc, char** argv)
{
    TMushArgumentList ArgumentList(argc, argv);
    if (ArgumentList.NumberOfParameters() < 2) {
	cerr << "Usage: " << argv[0];
	cerr << " [Options] DataFileName ScriptFileName" << endl;
	cerr << "Options:" << endl;
	cerr << "  --port=PORT_NUMBER" << endl;
	return EXIT_FAILURE;
    }
    string ScriptFileName = ArgumentList[1];
    
    TKinokoEventEmitter* EventEmitter = new TKinokoEventEmitter();
    TKinokoRegistry* Registry = new TKinokoNullRegistry();

    TKinokoViewer* Viewer = new TKinokoViewer(EventEmitter, Registry);
    TKinokoStandaloneComponent* StandaloneComponent = new TKinokoStandaloneDataConsumer(Viewer, "Viewer");

    try {
	Viewer->SetScript(ScriptFileName);
	StandaloneComponent->Start(ArgumentList);
    }
    catch (TKinokoException &e) {
	cerr << "ERROR: " << argv[0] << ": " << e << endl;
    }

    delete StandaloneComponent;
    delete Viewer;
    delete Registry;
    delete EventEmitter;

    return 0;
}
