/* kvscheck.cc */
/* Created by Enomoto Sanshiro on 18 July 2001 */
/* Last updated by Enomoto Sanshiro on 3 May 2002. */


#include <iostream>
#include <string>
#include "MushSignal.hh"
#include "MushArgumentList.hh"
#include "KinokoAnalysisSequenceBuilder.hh"
#include "KinokoView.hh"
#include "KinokoViewBuilder.hh"
#include "KinokoViewFactory.hh"
#include "KinokoViewBuilder.hh"
#include "KinokoViewScript.hh"

using namespace std;


class TKvsChecker {
  public:
    TKvsChecker(const string& ScriptFileName, const string& DisplayName, bool ShowsSequence);
    virtual ~TKvsChecker();
    virtual void Start(void) throw(TKinokoException);
  protected:
    string _ScriptFileName;
    string _DisplayName;
    bool _ShowsSequence;
};



TKvsChecker::TKvsChecker(const string& ScriptFileName, const string& DisplayName, bool ShowsSequence)
{
    _ScriptFileName = ScriptFileName;
    _DisplayName = DisplayName;
    _ShowsSequence = ShowsSequence;
}

TKvsChecker::~TKvsChecker()
{
}

void TKvsChecker::Start(void) throw(TKinokoException)
{
    ifstream ScriptFile(_ScriptFileName.c_str());
    if (! ScriptFile) {
	throw TKinokoException("unable to open file: " + _ScriptFileName);
    }

    TKinokoEventEmitter* EventEmitter = new TKinokoEventEmitter();
    TKinokoRegistry* Registry = new TKinokoNullRegistry();

    TKinokoAnalysisSequenceBuilder* AnalysisSequenceBuilder = (
	new TKinokoAnalysisSequenceBuilder(EventEmitter, Registry)
    );
    TKinokoViewFactory* ViewFactory = new TKinokoKoapViewFactory(&cout);
    TKinokoViewBuilder* ViewBuilder = new TKinokoViewBuilder(
	ViewFactory, EventEmitter, Registry
    );

    try {
	TKinokoViewScript ViewScript(
	    ViewBuilder, AnalysisSequenceBuilder, _ScriptFileName
	);
	ViewScript.Parse(ScriptFile);

	if (ViewScript.DisplayNameList().empty()) {
	    throw TScriptException(
		"script exception: no display entry defined"
	    );
	}

	if (_DisplayName.empty()) {
	    _DisplayName = ViewScript.DisplayNameList()[0];
	}
	ViewScript.Execute(_DisplayName);

	if (_ShowsSequence) {
	    AnalysisSequenceBuilder->DataDistributor()->Dump(cout);
	    ViewBuilder->SequenceTable()->Dump(cout);
	}
    }
    catch (TScriptException &e) {
        throw TKinokoException(e.Message());
    }
    catch (TKinokoException &e) {
        throw;
    }

    delete AnalysisSequenceBuilder;
    delete ViewBuilder;
    delete ViewFactory;
    delete Registry;
    delete EventEmitter;
}


int main(int argc, char **argv)
{
    TMushSignalHandler SignalHandler;
    SignalHandler.StartDefaultAction(SIGSEGV);
    SignalHandler.StartDefaultAction(SIGPIPE);

    if (argc < 2) {
	cerr << "Usage: " << argv[0];
	cerr << " [Options] ScriptFileName [DisplayName]" << endl;
	cerr << "Options:" << endl;
	cerr << "  --show-sequence  dumps sequence" << endl;
	return EXIT_FAILURE;
    }
    
    TMushArgumentList ArgumentList(argc, argv);
    string ScriptFileName = ArgumentList[0];
    string DisplayName = ArgumentList[1];
    bool ShowsSequence = ArgumentList.IsOptionSpecified("--show-sequence");
    
    try {
	TKvsChecker(ScriptFileName, DisplayName, ShowsSequence).Start();
    }
    catch (TKinokoException &e) {
	cout << e << endl;
    }

    return 0;
}
