#! /usr/bin/perl

# setVersion.pl
# Created by Sanshiro Enomoto on 18 February 2002.
# Last updated by Sanshiro Enomoto on 18 February 2002.


chop ($old_version = `kinoko-config --version`);

if (scalar(@ARGV) > 0) {
    $version = $ARGV[0];
}
else {
    if (! ($old_version =~ m/^([0-9]+)\.([0-9]+)\.([0-9]+)$/)) {
        print "bad version number string: $old_version\n";
	exit;
    }
    $release_number = $3 + 1;
    $version = "$1.$2.$release_number";
}

if (! ($version =~ m/^([0-9]+)\.([0-9]+)\.([0-9]+)$/)) {
    print "bad version number string: $version\n";
    print "current version is: $old_version\n";
    exit;
}

($cvs_tag = "ver-$version") =~ s/\./-/g;
$date = scalar(localtime(time));

print "New Version: $version\n";
print "CVS Revision Tag: $cvs_tag\n";
print "Release Date: $date\n";

print "continue? (y/n) > ";
$dicision = <STDIN>;
chop($dicision);

if ($dicision ne "y") {
    exit;
}


print "\n";
print "update configure.in? (y/n) > ";
$dicision = <STDIN>;
chop($dicision);

if ($dicision eq "y") {
    print "updating configure.in...\n";
    `mv configure.in configure.in.old`;
    open (OLD, "configure.in.old") or die "unable open file 'configure.in.old'\n";
    open (NEW, "> configure.in") or die "unable open file 'configure.in'\n";

    while (<OLD>) {
        s/^KINOKO_VERSION=\"[^\"]*\"/KINOKO_VERSION=\"$version\"/g;
        s/^KINOKO_RELEASE_DATE=\"[^\"]*\"/KINOKO_RELEASE_DATE=\"$date\"/g;
	print NEW $_;
    }

    close OLD;
    close NEW;
}


print "\n";
print "execute autoconf? (y/n) > ";
$dicision = <STDIN>;
chop($dicision);

if ($dicision eq "y") {
    print "executing 'autoconf'...\n";
    if (fork == 0) {
        exec "autoconf";
    }
    wait;
}


print "\n";
print "execute configure-for? (y/n) > ";
$dicision = <STDIN>;
chop($dicision);

if ($dicision eq "y") {
    print "enter system type: ";
    $type = <STDIN>;
    chop $type;

    print "enter compile option: ";
    $option = <STDIN>;
    chop $option;

    print "executing 'configure-for $type $option'...\n";
    if (fork == 0) {
        exec "./configure-for", $type, $option;
    }
    wait;
}


print "\n";
print "make kinoko-config? (y/n) > ";
$dicision = <STDIN>;
chop($dicision);

if ($dicision eq "y") {
    print "making kinoko-config...\n";
    if (fork == 0) {
        chdir "kernel/process";
        exec "make", "kinoko-config";
    }
    wait;
    if (fork == 0) {
        chdir "kernel/process";
        exec "make", "install";
    }
    wait;
}


print "\n";
print "commit to cvs? (yes/no) > ";
$dicision = <STDIN>;
chop($dicision);

if ($dicision eq "yes") {
    print "enter comment: ";
    $comment = <STDIN>;
    chop $comment;

    print "executing 'cvs commit -m $comment...\n";
    if (fork == 0) {
        chdir "..";
        exec "cvs", "commit", "-m", "$comment";
    }
    wait;
}


print "\n";
print "set tag to cvs? (yes/no) > ";
$dicision = <STDIN>;
chop($dicision);

if ($dicision eq "yes") {
    print "executing 'cvs tag $cvs_tag'...\n";

    if (fork == 0) {
        chdir "..";
        exec "cvs", "tag", "$cvs_tag";
    }
    wait;
}


print "\n";
print `kinoko-config`;
