/* KinokoBoard.cc */
/* Created by Enomoto Sanshiro on 29 October 2001. */
/* Last updated by Enomoto Sanshiro on 29 October 2001. */


#include <iostream>
#include <fstream>
#include <strstream>
#include <string>
#include "KinokoCanvasTextArea.hh"
#include "KinokoBoard.hh"

using namespace std;



TKinokoBoard::TKinokoBoard(TKinokoShellConnector* ShellConnector)
: TKinokoShell(ShellConnector)
{
}

TKinokoBoard::~TKinokoBoard()
{
}

void TKinokoBoard::Initialize(TKinokoCanvasTextArea* TextArea)
{
    _TextArea = TextArea;
}

int TKinokoBoard::ProcessSystemCommand(const string& Command, istream& InputStream) {
    int Result = 0;

    if (Command == ".write") {
	Result = ProcessWriteCommand(InputStream);
    }
    else if (Command == ".writeStatus") {
	Result = ProcessWriteStatusCommand(InputStream);
    }
    else if (Command == ".set") {
	Result = ProcessSetCommand(InputStream);
    }
    else if (Command == ".save") {
	Result = ProcessSaveCommand(InputStream);
    }
    else {
	Result = TKinokoShell::ProcessSystemCommand(Command, InputStream);
    }

    return Result;
}

int TKinokoBoard::ProcessWriteCommand(istream& InputStream)
{
    int Result = 0;

    string Line;
    if (getline(InputStream >> ws, Line)) {
	_TextArea->PutLine(Line + '\n');
	Result = 1;
    }

    return Result;
}

int TKinokoBoard::ProcessWriteStatusCommand(istream& InputStream)
{
    int Result = 0;

    string Line;
    if (getline(InputStream >> ws, Line)) {
	WriteStatusMessage(Line);
	Result = 1;
    }

    return Result;
}

int TKinokoBoard::ProcessSetCommand(istream& InputStream)
{
    string Name, Value;
    if (InputStream >> Name >> Value) {
	if (Name == "color") {
	    SetColor(Value);
	}
	else if (Name == "font") {
	    SetFont(Value);
	}
	else if (Name == "title") {
	    SetTitle(Value);
	}
	else {
	    return 0;
	}
    }
    else {
	return 0;
    }

    return 1;
}

int TKinokoBoard::ProcessSaveCommand(istream& InputStream)
{
    string FileName;
    if (InputStream >> FileName) {
	SaveTo(FileName);
    }

    return 1;
}

int TKinokoBoard::ProcessQuitCommand(istream& InputStream)
{
    Quit();
    return 1;
}

void TKinokoBoard::SaveTo(const string& FileName)
{
}

void TKinokoBoard::SetColor(const string& ColorName)
{
    _TextArea->SetTextColorByName(ColorName);
}

void TKinokoBoard::SetFont(const string& FontName)
{
}

void TKinokoBoard::SetTitle(const string& Title)
{
}

void TKinokoBoard::WriteStatusMessage(const string& Message)
{
}
