/* KinokoBoard.hh */
/* Created by Enomoto Sanshiro on 29 October 2001. */
/* Last updated by Enomoto Sanshiro on 29 October 2001. */


#ifndef __KinokoBoard_hh
#define __KinokoBoard_hh


#include <string>
#include "KinokoShell.hh"
#include "KinokoCanvasTextArea.hh"


class TKinokoBoard: public TKinokoShell {
  public:
    TKinokoBoard(TKinokoShellConnector* ShellConnector);
    virtual ~TKinokoBoard();
  public:
    virtual void SaveTo(const std::string& FileName);
    virtual void SetColor(const std::string& ColorName);
    virtual void SetFont(const std::string& FontName);
    virtual void SetTitle(const std::string& Title);
    virtual void WriteStatusMessage(const std::string& Message);
  protected:
    virtual int ProcessSystemCommand(const std::string& Command, std::istream& InputStream);
    virtual void Initialize(TKinokoCanvasTextArea* TextArea);
    virtual int ProcessWriteCommand(std::istream& InputStream);
    virtual int ProcessSetCommand(std::istream& InputStream);
    virtual int ProcessWriteStatusCommand(std::istream& InputStream);
    virtual int ProcessSaveCommand(std::istream& InputStream);
    virtual int ProcessQuitCommand(std::istream& InputStream);
  protected:
    TKinokoCanvasTextArea* _TextArea;
};


#endif
