/* KinokoCanvas.hh */
/* Created by Enomoto Sanshiro on 9 July 2000. */
/* Last updated by Enomoto Sanshiro on 27 March 2002. */


#ifndef __KinokoCanvas_hh
#define __KinokoCanvas_hh


#include <iostream>
#include <string>
#include "KinokoShell.hh"
#include "KinokoCanvasImageArea.hh"
#include "KinokoCanvasImageAreaEps.hh"
#include "KinokoCanvasObject.hh"


class TKinokoCanvas: public TKinokoShell {
  public:
    TKinokoCanvas(TKinokoShellConnector* ShellConnector);
    virtual ~TKinokoCanvas();
  public:
    virtual void AddCanvasObject(TKinokoCanvasObject* CanvasObject);
    virtual void OnClick(int ButtonNumber, int X, int Y);
    virtual int Redraw(void);
    virtual int Clear(void);
    virtual int SetTitle(const std::string& Title);
    virtual int SaveImageTo(const std::string& FileName);
    virtual int BeginEps(const std::string& FileName);
    virtual int EndEps(void);
  protected:
    virtual int OpenContextMenu(TKinokoCanvasObject* CanvasObject) = 0;
  protected:
    virtual int ProcessSystemCommand(const std::string& Command, std::istream& InputStream);
    virtual int ProcessCommand(std::istream& InputStream);
    virtual void Initialize(TKinokoCanvasImageArea* ImageArea, bool IsEpsEnabled = false);
    virtual int ProcessSetCommand(std::istream& InputStream);
    virtual int ProcessRedrawCommand(std::istream& InputStream);
    virtual int ProcessClearCommand(std::istream& InputStream);
    virtual int ProcessSaveImageCommand(std::istream& InputStream);
    virtual int ProcessBeginEpsCommand(std::istream& InputStream);
    virtual int ProcessEndEpsCommand(std::istream& InputStream);
  protected:
    TKinokoCanvasImageArea* _ImageArea;
    TKinokoCanvasImageAreaEps* _EpsImageArea;
    bool _IsAutoRedrawEnabled;
    std::vector<TKinokoCanvasObject*> _CanvasObjectList;
};


#endif
