/* KinokoCanvas3dPlotObject.hh */
/* Created by Enomoto Sanshiro on 11 July 2000. */
/* Last updated by Enomoto Sanshiro on 4 November 2002. */


#ifndef __KinokoCanvas3dPlotObject_hh
#define __KinokoCanvas3dPlotObject_hh


#include <string>
#include <iostream>
#include "KinokoCanvasPlotObject.hh"



class TKinokoCanvas3dPlotObject: public TKinokoCanvasPlotObject {
  public:
    TKinokoCanvas3dPlotObject(TKinokoCanvas* Canvas, TKinokoCanvasImageArea* ImageArea, bool IsMonochrome = false);
    virtual ~TKinokoCanvas3dPlotObject();
    virtual TKinokoShellObject* Clone();
    virtual std::vector<std::string> ActionList(void);
    virtual int ProcessAction(const std::string& ActionName);
  protected:
    virtual int SetZCoordinate(float ZMin, float ZWidth);
    virtual int SetZScaleLinear(void);
    virtual int SetZScaleLog(void);
  protected:
    virtual int ProcessCommand(const std::string& Command, std::istream& InputStream);
    virtual int ProcessSetCommand(const std::string& Name, const std::string& Value);
    virtual int ProcessFrameCommand(std::istream& InputStream);
    virtual int Process2dHistCommand(std::istream& InputStream, int Type);
    virtual int ProcessContourCommand(std::istream& InputStream);
  protected:
    float _ZMin, _ZMax, _ZWidth;
    float _LogZMin, _LogZMax, _LogZWidth;
    float _ZMinOrg, _ZWidthOrg;
    bool _IsZScaleLog, _IsMonochrome;
    TKinokoCanvasColorScale* _ColorScale;
  protected:
    enum TPlotType {
	Type_Scatter,
	Type_Box,
	Type_Color,
	_NumberOfPlotTypes
    };
};



class TKinokoCanvasZScaled3dPlotObject: public TKinokoCanvas3dPlotObject, public TKinokoCanvasColorScaledObject {
  public:
    TKinokoCanvasZScaled3dPlotObject(TKinokoCanvas* Canvas, TKinokoCanvasImageArea* ImageArea, bool IsMonochrome = false);
    virtual ~TKinokoCanvasZScaled3dPlotObject();
    virtual TKinokoShellObject* Clone(void);
  protected:
    virtual int SetZScaleLinear(void);
    virtual int SetZScaleLog(void);
    virtual int DrawFrame(void);
  protected:
    virtual int ProcessFrameCommand(std::istream& InputStream);
};


#endif
