/* KinokoCanvasDataScale.hh */
/* Created by Enomoto Sanshiro on 11 July 2000. */
/* Last updated by Enomoto Sanshiro on 9 January 2002. */


#ifndef __KinokoCanvasDataScale_hh
#define __KinokoCanvasDataScale_hh


#include <vector>


class TKinokoCanvasDataScale {
  public:
    TKinokoCanvasDataScale(float Min = 0, float Max = 1.0);
    virtual ~TKinokoCanvasDataScale();
    virtual TKinokoCanvasDataScale& Rescale(float Min, float Max);
    virtual float Min(void) const;
    virtual float Max(void) const;
    virtual float Width(void) const;
    virtual int NumberOfDivisions(void);
    virtual float DivisionValueOf(int DivisionIndex);
  protected:
    static std::pair<float, float> DecideSteps(float Min, float Max, int Mag = 0);
  protected:
    float _Min, _Max, _Width;
    float _FirstDivision, _DivisionStep;
    int _NumberOfDivisions;
  private:
    float _UsedMin, _UsedMax;
};


class TKinokoCanvasLogDataScale: public TKinokoCanvasDataScale {
  public:
    TKinokoCanvasLogDataScale(float Min = 0.1, float Max = 1.0);
    virtual ~TKinokoCanvasLogDataScale();
    virtual TKinokoCanvasDataScale& Rescale(float Min, float Max);
    virtual int NumberOfDivisions(void);
    virtual float DivisionValueOf(int DivisionIndex);
  protected:
    bool _IsUsingNormalScale;
};


#endif
