/* KinokoCanvasDrawableObject.hh */
/* Created by Enomoto Sanshiro on 11 July 2000. */
/* Last updated by Enomoto Sanshiro on 9 January 2002. */


#ifndef __KinokoCanvasDrawableObject_hh
#define __KinokoCanvasDrawableObject_hh


#include <iostream>
#include <string>
#include <deque>
#include "KinokoCanvasObject.hh"


class TKinokoCanvasDrawableObject: public TKinokoCanvasObject {
  public:
    TKinokoCanvasDrawableObject(TKinokoCanvas* Canvas, TKinokoCanvasImageArea* ImageArea);
    virtual ~TKinokoCanvasDrawableObject();
  protected:
    virtual int ProcessCommand(const std::string& Command, std::istream& InputStream);
    virtual int ProcessSetCommand(const std::string& Name, const std::string& Value);
    virtual int ProcessClearCommand(std::istream& InputStream);
    virtual int ProcessSaveContextCommand(std::istream& InputStream);
    virtual int ProcessRestoreContextCommand(std::istream& InputStream);
    virtual int ProcessDrawTextCommand(std::istream& InputStream);
    virtual int ProcessDrawLineCommand(std::istream& InputStream);
    virtual int ProcessDrawRectCommand(std::istream& InputStream);
    virtual int ProcessDrawRectFillCommand(std::istream& InputStream);
    virtual int ProcessDrawCircleCommand(std::istream& InputStream);
    virtual int ProcessDrawCircleFillCommand(std::istream& InputStream);
    virtual int ProcessDrawImageCommand(std::istream& InputStream);
    virtual int ProcessSetFontCommand(std::istream& InputStream);
  protected:
    virtual float CanvasXOf(float x);
    virtual float CanvasYOf(float y);
    virtual int SetCoordinate(float XMin, float YMin, float XWidth, float YWidth);
    virtual int SaveContext(void);
    virtual int RestoreContext(void);
  protected:
    int SetColor(const std::string& ColorName);
    int SetFont(const std::string& FontName, int FontSize);
    int SetLineWidth(const std::string& LineWidthString);
    int SetLineStyle(const std::string& LineStyleString);
  protected:
    int _ColorIndex;
    int _LineWidth;
    int _LineStyleIndex;
    int _FontIndex;
    std::string _TextAdjustment;
    float _XMin, _XMax, _YMin, _YMax, _XWidth, _YWidth;
  private:
    std::deque<int> _ColorIndexStack;
    std::deque<int> _LineWidthStack;
    std::deque<int> _LineStyleIndexStack;
    std::deque<int> _FontIndexStack;
    std::deque<std::string> _TextAdjustmentStack;
};


#endif
