/* KinokoCanvasImageArea.hh */
/* Created by Enomoto Sanshiro on 10 July 2000. */
/* Last updated by Enomoto Sanshiro on 12 April 2003. */


#ifndef __KinokoCanvasImageArea_hh
#define __KinokoCanvasImageArea_hh


#include <string>
#include <vector>


class TKinokoCanvasImage;
class TKinokoCanvasColor;

class TKinokoCanvasImageArea {
  public:
    TKinokoCanvasImageArea(int Width, int Height);
    virtual ~TKinokoCanvasImageArea();
    virtual void Redraw(void) = 0;
    virtual void Clear(void) = 0;
    virtual int SaveImageTo(const std::string& FileName) = 0;
    virtual int Width(void);
    virtual int Height(void);
  public:
    virtual void DrawPoint(float x, float y) = 0;
    virtual void DrawLine(float x0, float y0, float x1, float y1) = 0;
    virtual void DrawRect(float x0, float y0, float x1, float y1) = 0;
    virtual void DrawRectFill(float x0, float y0, float x1, float y1) = 0;
    virtual void DrawLines(const std::vector<std::pair<float, float> >& PointList) = 0;
    virtual void DrawPolygon(const std::vector<std::pair<float, float> >& PointList) = 0;
    virtual void DrawPolygonFill(const std::vector<std::pair<float, float> >& PointList) = 0;
    virtual void DrawCircle(float x, float y, float r) = 0;
    virtual void DrawCircleFill(float x, float y, float r) = 0;
    virtual void DrawEllipse(float x, float y, float rx, float ry) = 0;
    virtual void DrawEllipseFill(float x, float y, float rx, float ry) = 0;
    virtual void DrawText(float x, float y, const std::string& Text, const std::string& Adjustment = "") = 0;
    virtual void DrawNumberText(float x, float y, float Number, const std::string& Adjustment = "");
    virtual int AllocateColor(const std::string& ColorName) = 0;
    virtual int AllocateColorRgb(float Red, float Green, float Blue) = 0;
    virtual int SetColor(int ColorIndex) = 0;
    virtual bool GetColor(int ColorIndex, TKinokoCanvasColor& Color) = 0;
    virtual int SetLineWidth(int LineWidth) = 0;
    virtual int CreateLineStyle(const std::string& LineStyleName) = 0;
    virtual int SetLineStyle(int LineStyleIndex = 0, unsigned Offset = 0) = 0;
    virtual bool GetLineStyle(int LineStyleIndex, std::vector<int>& LineStyle) = 0;
    virtual int LoadFont(const std::string& FontName, int FontSize) = 0;
    virtual int SetFont(int FontIndex) = 0;
    virtual std::string SetTextAdjustment(const std::string& Adjustment) = 0;
    virtual int SetTextOrientation(int Digree) = 0;
    virtual int TextHeightOf(const std::string& Text) = 0;
    virtual int TextAscentOf(const std::string& Text) = 0;
    virtual int TextWidthOf(const std::string& Text) = 0;
    virtual TKinokoCanvasImage* LoadXpmImage(const std::string& FileName) = 0;
    virtual void DrawImage(float x, float y, TKinokoCanvasImage* Image) = 0;
  protected:
    int _Width;
    int _Height;
  protected:
    enum TTextAdjustment {
	TextAdjustment_Top, 
	TextAdjustment_Bottom, 
	TextAdjustment_Left, 
	TextAdjustment_Right, 
	TextAdjustment_Center
    };
};


class TKinokoCanvasColor {
  public:
    TKinokoCanvasColor(void);
    TKinokoCanvasColor(float Red, float Green, float Blue);
    virtual ~TKinokoCanvasColor();
    virtual float Red(void);
    virtual float Green(void);
    virtual float Blue(void);
  protected:
    float _Red, _Green, _Blue;
};


class TKinokoCanvasImage {
  public:
    TKinokoCanvasImage(int ImageId, int Width, int Height);
    virtual ~TKinokoCanvasImage();
    virtual int ImageId(void);
    virtual int Width(void);
    virtual int Height(void);
  protected:
    int _ImageId;
    int _Width, _Height;
};


#endif

