/* KinokoCanvasImageAreaEps.cc */
/* Created by Enomoto Sanshiro on 21 May 2002. */
/* Last updated by Enomoto Sanshiro on 12 April 2003. */


// ********************************************* //
// * THIS CODE IS VERY INCOMPLETE. DO NOT USE. * //
// ********************************************* //


#include <fstream>
#include <iomanip>
#include <strstream>
#include <string>
#include <vector>
#include <map>
#include <cmath>
#include "MushMisc.hh"
#include "KinokoCanvasImageArea.hh"
#include "KinokoCanvasImageAreaEps.hh"

using namespace std;


TKinokoCanvasImageAreaEps::TKinokoCanvasImageAreaEps(int Width, int Height, TKinokoCanvasImageArea* PrimaryImageArea)
: TKinokoCanvasImageArea(Width, Height)
{
    _PrimaryImageArea = PrimaryImageArea;

    _File = 0;

    _CurrentColorIndex = 0;
    _CurrentLineWidth = 1;
    _CurrentLineStyleIndex = 0;
    _CurrentFontIndex = 0;
    _CurrentTextOrientation = 0;

    _PredefinedFontNameTable["times"] = "Times-Roman";
    _PredefinedFontNameTable["times-roman"] = "Times-Roman";
    _PredefinedFontNameTable["times-italic"] = "Times-Italic";
    _PredefinedFontNameTable["times-bold"] = "Times-Bold";
    _PredefinedFontNameTable["times-bolditalic"] = "Times-BoldItalic";
    _PredefinedFontNameTable["helvetica"] = "Helvetica";
    _PredefinedFontNameTable["helvetica-oblique"] = "Helvetica-Oblique";
    _PredefinedFontNameTable["helvetica-bold"] = "Helvetica-Bold";
    _PredefinedFontNameTable["helvetica-boldoblique"] = "Helvetica-BoldOblique";
    _PredefinedFontNameTable["courier"] = "Courier";
    _PredefinedFontNameTable["courier-oblique"] = "Courier-Oblique";
    _PredefinedFontNameTable["courier-bold"] = "Courier-Bold";
    _PredefinedFontNameTable["courier-boldoblique"] = "Courier-BoldOblique";
    _PredefinedFontNameTable["symbol"] = "Symbol";
}

TKinokoCanvasImageAreaEps::~TKinokoCanvasImageAreaEps()
{
    delete _File;
}

int TKinokoCanvasImageAreaEps::Open(const std::string& FileName)
{
    _File = new ofstream(FileName.c_str());
    if (! *_File) {
	delete _File;
	_File = 0;
	return 0;
    }

    float x0 = DeviceXOf(0);
    float y0 = DeviceYOf(_Height);
    float x1 = DeviceXOf(_Width);
    float y1 = DeviceYOf(0);

    *_File << "%!PS-Adobe-2.0 EPSF-2.0" << endl;
    *_File << "%%BoundingBox: ";
    *_File << x0 << " " << y0 << " " << x1 << " " << y1 << endl;
    *_File << "%%Title: (" << FileName << ")" << endl;
    *_File << "%%Creator: (KinokoCanvas)" << endl;
    *_File << "%%CreationDate: " ;
    *_File << "(" << TMushDateTime().AsString("%d/%m/%Y %H:%M") << ")" << endl;
    *_File << "%%EndComments" << endl;
    *_File << endl;

    *_File << "%%BeginProlog" << endl;
    *_File << "/kinokodict 16 dict def" << endl;
    *_File << "kinokodict /mtrx matrix put" << endl;
    *_File << "/kinokoellipse {" << endl;
    *_File << "  kinokodict begin" << endl;
    *_File << "  /yrad exch def /xrad exch def" << endl;
    *_File << "  /y exch def /x exch def" << endl;
    *_File << "  newpath" << endl;
    *_File << "  /savematrix mtrx currentmatrix def" << endl;
    *_File << "  x y translate" << endl;
    *_File << "  xrad yrad scale" << endl;
    *_File << "  0 0 1 0 360 arc" << endl;
    *_File << "  savematrix setmatrix" << endl;
    *_File << "  closepath" << endl;
    *_File << "  end" << endl;
    *_File << "} def" << endl;
    *_File << "%%EndProlog" << endl;
    *_File << endl;

    *_File << "true {" << endl;
    *_File << "  /margin 0 def" << endl;
    *_File << "  clippath pathbbox /y1 exch def /x1 exch def /y0 exch def /x0 exch def" << endl;
    *_File << "  /pw x1 x0 sub def /ph y1 y0 sub def" << endl;
    *_File << "  /iw " << _Width << " def /ih " << _Height << " def" << endl;
    *_File << "  /rx pw 2 margin mul sub iw div def" << endl;
    *_File << "  /ry ph 2 margin mul sub ih div def" << endl;
    *_File << "  rx ry le {" << endl;
    *_File << "    /r rx def" << endl;
    *_File << "    /x x0 margin add def" << endl;
    *_File << "  } {" << endl;
    *_File << "    /r ry def" << endl;
    *_File << "    /x x0 x1 add iw r mul sub 2 div def" << endl;
    *_File << "  } ifelse" << endl;
    *_File << "  x ph margin sub ih r mul sub translate" << endl;
    *_File << "  r r scale" << endl;
    *_File << "} if" << endl;
    *_File << endl;

    string DefaultFontName = "Helvetica";
    int DefaultFontSize = 14;
    _FontNameTable[0] = make_pair(DefaultFontName, DefaultFontSize);
    _ColorTable[0] = TKinokoCanvasColor(0, 0, 0);

    *_File << "/" << DefaultFontName << " findfont" << " ";
    *_File << DefaultFontSize << " scalefont setfont" << endl;

    return 1;
}

int TKinokoCanvasImageAreaEps::Close(void)
{
    if (_File) {
	*_File << "showpage" << endl;
	*_File << "%%EOF" << endl;

	delete _File;
	_File = 0;
    }

    return 1;
}


float TKinokoCanvasImageAreaEps::DeviceXOf(float x)
{
    return 1.0 * x;
}

float TKinokoCanvasImageAreaEps::DeviceYOf(float y)
{
    return (1.0 * (_Height - y));
}

void TKinokoCanvasImageAreaEps::Redraw(void)
{
    _PrimaryImageArea->Redraw();
}

void TKinokoCanvasImageAreaEps::Clear(void)
{
    //...
    _PrimaryImageArea->Clear();
}

int TKinokoCanvasImageAreaEps::SaveImageTo(const string& FileName)
{
    return _PrimaryImageArea->SaveImageTo(FileName);
}

void TKinokoCanvasImageAreaEps::DrawPoint(float x, float y)
{
    _PrimaryImageArea->DrawPoint(x, y);

    if (_File) {
	float r = 1.0;
	*_File << DeviceXOf(x) << " " << DeviceYOf(y);
	*_File << " " << r << " " << r << " ";
	*_File << "kinokoellipse" << " ";
	*_File << "fill" << endl;
    }
}

void TKinokoCanvasImageAreaEps::DrawLine(float x0, float y0, float x1, float y1)
{
    _PrimaryImageArea->DrawLine(x0, y0, x1, y1);

    if (_File) {
	*_File << "newpath" << " ";
	*_File << DeviceXOf(x0) << " " << DeviceYOf(y0) << " moveto" << " ";
	*_File << DeviceXOf(x1) << " " << DeviceYOf(y1) << " lineto" << " ";
	*_File << "stroke" << endl;
    }
}

void TKinokoCanvasImageAreaEps::DrawRect(float x0, float y0, float x1, float y1)
{
    _PrimaryImageArea->DrawRect(x0, y0, x1, y1);

    if (_File) {
	*_File << "newpath" << " ";
	*_File << DeviceXOf(x0) << " " << DeviceYOf(y0) << " moveto" << " ";
	*_File << DeviceXOf(x1) << " " << DeviceYOf(y0) << " lineto" << " ";
	*_File << DeviceXOf(x1) << " " << DeviceYOf(y1) << " lineto" << " ";
	*_File << DeviceXOf(x0) << " " << DeviceYOf(y1) << " lineto" << " ";
	*_File << "closepath" << " ";
	*_File << "stroke" << endl;
    }
}

void TKinokoCanvasImageAreaEps::DrawRectFill(float x0, float y0, float x1, float y1)
{
    _PrimaryImageArea->DrawRectFill(x0, y0, x1, y1);

    if (_File) {
	*_File << "newpath" << " ";
	*_File << DeviceXOf(x0) << " " << DeviceYOf(y0) << " moveto" << " ";
	*_File << DeviceXOf(x1) << " " << DeviceYOf(y0) << " lineto" << " ";
	*_File << DeviceXOf(x1) << " " << DeviceYOf(y1) << " lineto" << " ";
	*_File << DeviceXOf(x0) << " " << DeviceYOf(y1) << " lineto" << " ";
	*_File << "closepath" << " ";
	*_File << "fill" << endl;
    }
}

void TKinokoCanvasImageAreaEps::DrawLines(const vector<pair<float, float> >& PointList)
{
    _PrimaryImageArea->DrawLines(PointList);

    if (_File) {
	*_File << "newpath" << " ";
	if (PointList.size() > 0) {
	    *_File << DeviceXOf(PointList[0].first) << " ";
	    *_File << DeviceYOf(PointList[0].second) << " ";
	    *_File << "moveto" << " ";
	}
	for (unsigned i = 1; i < PointList.size(); i++) {
	    *_File << DeviceXOf(PointList[i].first) << " ";
	    *_File << DeviceYOf(PointList[i].second) << " ";
	    *_File << "lineto" << " ";
	}
	*_File << "stroke" << endl;
    }
}

void TKinokoCanvasImageAreaEps::DrawPolygon(const vector<pair<float, float> >& PointList)
{
    _PrimaryImageArea->DrawPolygon(PointList);

    if (_File) {
	*_File << "newpath" << " ";
	if (PointList.size() > 0) {
	    *_File << DeviceXOf(PointList[0].first) << " ";
	    *_File << DeviceYOf(PointList[0].second) << " ";
	    *_File << "moveto" << " ";
	}
	for (unsigned i = 1; i < PointList.size(); i++) {
	    *_File << DeviceXOf(PointList[i].first) << " ";
	    *_File << DeviceYOf(PointList[i].second) << " ";
	    *_File << "lineto" << " ";
	}
	*_File << "closepath stroke" << endl;
    }
}

void TKinokoCanvasImageAreaEps::DrawPolygonFill(const vector<pair<float, float> >& PointList)
{
    _PrimaryImageArea->DrawPolygonFill(PointList);

    if (_File) {
	*_File << "newpath" << " ";
	if (PointList.size() > 0) {
	    *_File << DeviceXOf(PointList[0].first) << " ";
	    *_File << DeviceYOf(PointList[0].second) << " ";
	    *_File << "moveto" << " ";
	}
	for (unsigned i = 1; i < PointList.size(); i++) {
	    *_File << DeviceXOf(PointList[i].first) << " ";
	    *_File << DeviceYOf(PointList[i].second) << " ";
	    *_File << "lineto" << " ";
	}
	*_File << "closepath fill" << endl;
    }
}

void TKinokoCanvasImageAreaEps::DrawCircle(float x, float y, float r)
{
    _PrimaryImageArea->DrawCircle(x, y, r);

    if (_File) {
	float RadiusX = fabs(DeviceXOf(x + r) - DeviceXOf(x));
	float RadiusY = fabs(DeviceYOf(y + r) - DeviceYOf(y));
	*_File << DeviceXOf(x) << " " << DeviceYOf(y) << " ";
	*_File << RadiusX << " " << RadiusY << " ";
	*_File << "kinokoellipse stroke" << endl;
    }
}

void TKinokoCanvasImageAreaEps::DrawCircleFill(float x, float y, float r)
{
    _PrimaryImageArea->DrawCircleFill(x, y, r);

    if (_File) {
	float RadiusX = fabs(DeviceXOf(x + r) - DeviceXOf(x));
	float RadiusY = fabs(DeviceYOf(y + r) - DeviceYOf(y));
	*_File << DeviceXOf(x) << " " << DeviceYOf(y) << " ";
	*_File << RadiusX << " " << RadiusY << " ";
	*_File << "kinokoellipse fill" << endl;
    }
}

void TKinokoCanvasImageAreaEps::DrawEllipse(float x, float y, float rx, float ry)
{
    _PrimaryImageArea->DrawEllipse(x, y, rx, ry);

    if (_File) {
	float RadiusX = fabs(DeviceXOf(x + rx) - DeviceXOf(x));
	float RadiusY = fabs(DeviceYOf(y + ry) - DeviceYOf(y));
	*_File << "gsave" << endl;
	*_File << DeviceXOf(x) << " " << DeviceYOf(y) << " ";
	*_File << RadiusX << " " << RadiusY << " ";
	*_File << "kinokoellipse stroke" << endl;
	*_File << "grestore";
	*_File << endl;
    }
}

void TKinokoCanvasImageAreaEps::DrawEllipseFill(float x, float y, float rx, float ry)
{
    _PrimaryImageArea->DrawEllipseFill(x, y, rx, ry);

    if (_File) {
	float RadiusX = fabs(DeviceXOf(x + rx) - DeviceXOf(x));
	float RadiusY = fabs(DeviceYOf(y + ry) - DeviceYOf(y));
	*_File << "gsave" << endl;
	*_File << DeviceXOf(x) << " " << DeviceYOf(y) << " ";
	*_File << RadiusX << " " << RadiusY << " ";
	*_File << "kinokoellipse fill" << endl;
	*_File << "grestore";
	*_File << endl;
    }
}

void TKinokoCanvasImageAreaEps::DrawText(float x, float y, const string& Text, const string& Adjustment)
{
    _PrimaryImageArea->DrawText(x, y, Text, Adjustment);

    if (! _File || Text.empty()) {
	return;
    }

    if (! Adjustment.empty()) {
	SetTextAdjustment(Adjustment);
    }

    *_File << "gsave" << endl;

    string EscapedText;
    for (unsigned i = 0; i < Text.size(); i++) {
	char Char = Text[i];
	if ((Char == '(') || (Char == ')')) {
	    EscapedText += '\\';
	}
	EscapedText += Char;
    }

    *_File << "(" << EscapedText << ") dup" << endl;

    *_File << "newpath" << " ";
    *_File << "0 0 moveto" << " ";
    *_File << /*Text*/ "false charpath" << " ";
    *_File << "pathbbox" << endl;
    *_File << "/h exch def /w exch def pop pop" << endl;

    *_File << "/x " << DeviceXOf(x) << " def" << " ";
    *_File << "/y " << DeviceYOf(y) << " def" << " ";
    *_File << "/d " << _CurrentTextOrientation << " def" << endl;

    if (_CurrentTextOrientation != 0) {
	*_File << "/w1 d cos abs w mul d sin abs h mul add def" << endl;
	*_File << "/h1 d sin abs w mul d cos abs h mul add def" << endl;
    }
    else {
	*_File << "/w1 w def" << endl;
	*_File << "/h1 h def" << endl;
    }

    if (_HorizontalTextAdjustment == TextAdjustment_Right) {
	*_File << "x w1 2 div sub" << " ";
    }
    else if (_HorizontalTextAdjustment == TextAdjustment_Left) {
	*_File << "x w1 2 div add" << " ";
    }
    else {
	*_File << "x" << " ";
    }
    if (_VerticalTextAdjustment == TextAdjustment_Top) {
	*_File << "y h1 2 div sub" << " ";
    }
    else if (_VerticalTextAdjustment == TextAdjustment_Bottom) {
	*_File << "y h1 2 div add" << " ";
    }
    else {
	*_File << "y" << " ";
    }
    *_File << "translate d rotate" << endl;

    *_File << "w -2 div h -2 div moveto" << " ";
    *_File << /*Text*/ "show" << endl;

    *_File << "grestore" << endl;
}

int TKinokoCanvasImageAreaEps::AllocateColor(const std::string& ColorName)
{
    int ColorIndex = _PrimaryImageArea->AllocateColor(ColorName);

    if (_ColorTable.count(ColorIndex) == 0) {
	_PrimaryImageArea->GetColor(ColorIndex, _ColorTable[ColorIndex]);
    }

    return ColorIndex;
}

int TKinokoCanvasImageAreaEps::AllocateColorRgb(float Red, float Green, float Blue)
{
    int ColorIndex = _PrimaryImageArea->AllocateColorRgb(Red, Green, Blue);
    _ColorTable[ColorIndex] = TKinokoCanvasColor(Red, Green, Blue);

    return ColorIndex;
}

int TKinokoCanvasImageAreaEps::SetColor(int ColorIndex)
{
    if (ColorIndex == _CurrentColorIndex) {
	return _CurrentColorIndex;
    }

    int OldColorIndex = _PrimaryImageArea->SetColor(ColorIndex);
    _CurrentColorIndex = ColorIndex;

    if (_File) {
	*_File << _ColorTable[ColorIndex].Red() << " ";
	*_File << _ColorTable[ColorIndex].Green() << " ";
	*_File << _ColorTable[ColorIndex].Blue() << " ";
	*_File << "setrgbcolor" << endl;
    }

    return OldColorIndex;
}

bool TKinokoCanvasImageAreaEps::GetColor(int ColorIndex, TKinokoCanvasColor& Color)
{
    return _PrimaryImageArea->GetColor(ColorIndex, Color);
}

int TKinokoCanvasImageAreaEps::SetLineWidth(int LineWidth)
{
    if (LineWidth == _CurrentLineWidth) {
	return _CurrentLineWidth;
    }

    int OldLineWidth = _PrimaryImageArea->SetLineWidth(LineWidth);
    _CurrentLineWidth = LineWidth;

    if (_File) {
	*_File << LineWidth << " setlinewidth" << endl;
    }

    return OldLineWidth;
}

int TKinokoCanvasImageAreaEps::CreateLineStyle(const string& LineStyleName)
{
    int LineStyleIndex =  _PrimaryImageArea->CreateLineStyle(LineStyleName);

    if (LineStyleIndex <= 0) {
	return LineStyleIndex;
    }

    if (_LineStyleTable.count(LineStyleIndex) == 0) {
	vector<int> LineStyle;
	_PrimaryImageArea->GetLineStyle(LineStyleIndex, LineStyle);

	ostrstream LineStyleStream;
	LineStyleStream << "[ ";
	for (unsigned i = 0; i < LineStyle.size(); i++) {
	    LineStyleStream << LineStyle[i] << " ";
	}
	LineStyleStream << "] " << ends;

	_LineStyleTable[LineStyleIndex] = LineStyleStream.str();
    }

    return LineStyleIndex;
}

int TKinokoCanvasImageAreaEps::SetLineStyle(int LineStyleIndex, unsigned Offset)
{
    if (LineStyleIndex == _CurrentLineStyleIndex) {
	return _CurrentLineStyleIndex;
    }

    int OldLineStyleIndex = _PrimaryImageArea->SetLineStyle(LineStyleIndex, Offset);
    _CurrentLineStyleIndex = LineStyleIndex;

    if (_File) {
	if (LineStyleIndex <= 0) {
	    *_File << "[] 0 setdash" << endl;
	}
	else if (_LineStyleTable.count(LineStyleIndex)) {
	    *_File << _LineStyleTable[LineStyleIndex] << " ";
	    *_File << Offset << " setdash" << endl;
	}
    }

    return OldLineStyleIndex;
}

bool TKinokoCanvasImageAreaEps::GetLineStyle(int LineStyleIndex, vector<int>& LineStyle)
{
    return _PrimaryImageArea->GetLineStyle(LineStyleIndex, LineStyle);
}

int TKinokoCanvasImageAreaEps::LoadFont(const string& FontName, int FontSize)
{
    int FontIndex = _PrimaryImageArea->LoadFont(FontName, FontSize);

    if (FontIndex < 0) {
	return FontIndex;
    }

    string SystemFontName;
    if (_PredefinedFontNameTable.count(FontName) > 0) {
	SystemFontName = _PredefinedFontNameTable[FontName];
    }
    else {
	SystemFontName = "TimesRoman";
    }
    if (! SystemFontName.empty()) {
	_FontNameTable[FontIndex] = make_pair(SystemFontName, FontSize);
    }

    return FontIndex;
}

int TKinokoCanvasImageAreaEps::SetFont(int FontIndex)
{
    if (FontIndex == _CurrentFontIndex) {
	return _CurrentFontIndex;
    }

    int OldFontIndex = _PrimaryImageArea->SetFont(FontIndex);
    _CurrentFontIndex = FontIndex;

    if (_File) {
	string FontName = _FontNameTable[FontIndex].first;
	int FontSize = _FontNameTable[FontIndex].second;
	if (FontSize > 0) {
	    *_File << "/" << FontName << " findfont" << " ";
	    *_File << FontSize << " scalefont setfont" << endl;
	}
    }

    return OldFontIndex;
}

string TKinokoCanvasImageAreaEps::SetTextAdjustment(const string& Adjustment)
{
    string OldAdjustment = _PrimaryImageArea->SetTextAdjustment(Adjustment);

    _HorizontalTextAdjustment = TextAdjustment_Center;
    _VerticalTextAdjustment = TextAdjustment_Center;

    if (Adjustment.find_first_of('t') != string::npos) {
	_VerticalTextAdjustment = TextAdjustment_Top;
    }
    if (Adjustment.find_first_of('b') != string::npos) {
	_VerticalTextAdjustment = TextAdjustment_Bottom;
    }
    if (Adjustment.find_first_of('l') != string::npos) {
	_HorizontalTextAdjustment = TextAdjustment_Left;
    }
    if (Adjustment.find_first_of('r') != string::npos) {
	_HorizontalTextAdjustment = TextAdjustment_Right;
    }

    return OldAdjustment;
}

int TKinokoCanvasImageAreaEps::SetTextOrientation(int Digree)
{
    int OldTextOrientation = _PrimaryImageArea->SetTextOrientation(Digree);
    _CurrentTextOrientation = Digree;

    return OldTextOrientation;
}

int TKinokoCanvasImageAreaEps::TextHeightOf(const string& Text)
{
    return _PrimaryImageArea->TextHeightOf(Text);
}

int TKinokoCanvasImageAreaEps::TextAscentOf(const string& Text)
{
    return _PrimaryImageArea->TextAscentOf(Text);
}

int TKinokoCanvasImageAreaEps::TextWidthOf(const string& Text)
{
    return _PrimaryImageArea->TextWidthOf(Text);
}

TKinokoCanvasImage* TKinokoCanvasImageAreaEps::LoadXpmImage(const string& FileName)
{
    return _PrimaryImageArea->LoadXpmImage(FileName);
}

void TKinokoCanvasImageAreaEps::DrawImage(float x, float y, TKinokoCanvasImage* Image)
{
    _PrimaryImageArea->DrawImage(x, y, Image);
}
