/* KinokoCanvasImageAreaEps.hh */
/* Created by Enomoto Sanshiro on 21 May 2002. */
/* Last updated by Enomoto Sanshiro on 12 April 2003. */


// ********************************************* //
// * THIS CODE IS VERY INCOMPLETE. DO NOT USE. * //
// *******************************+************* //


#ifndef __KinokoCanvasImageAreaEps_hh
#define __KinokoCanvasImageAreaEps_hh


#include <iostream>
#include <string>
#include <vector>
#include <map>
#include "KinokoCanvasImageArea.hh"


class TKinokoCanvasImageAreaEps: public TKinokoCanvasImageArea {
  public:
    TKinokoCanvasImageAreaEps(int Width, int Height, TKinokoCanvasImageArea* PrimaryImageArea);
    virtual ~TKinokoCanvasImageAreaEps();
    virtual void Redraw(void);
    virtual void Clear(void);
    virtual int SaveImageTo(const std::string& FileName);
    virtual int Open(const std::string& FileName);
    virtual int Close(void);
  public:
    virtual void DrawPoint(float x, float y);
    virtual void DrawLine(float x0, float y0, float x1, float y1);
    virtual void DrawRect(float x0, float y0, float x1, float y1);
    virtual void DrawRectFill(float x0, float y0, float x1, float y1);
    virtual void DrawLines(const std::vector<std::pair<float, float> >& PointList);
    virtual void DrawPolygon(const std::vector<std::pair<float, float> >& PointList);
    virtual void DrawPolygonFill(const std::vector<std::pair<float, float> >& PointList);
    virtual void DrawCircle(float x, float y, float r);
    virtual void DrawCircleFill(float x, float y, float r);
    virtual void DrawEllipse(float x, float y, float rx, float ry);
    virtual void DrawEllipseFill(float x, float y, float rx, float ry);
    virtual void DrawText(float x, float y, const std::string& Text, const std::string& Adjustment = "");
    virtual int AllocateColor(const std::string& ColorName);
    virtual int AllocateColorRgb(float Red, float Green, float Blue);
    virtual int SetColor(int ColorIndex);
    virtual bool GetColor(int ColorIndex, TKinokoCanvasColor& Color);
    virtual int SetLineWidth(int LineWidth);
    virtual int CreateLineStyle(const std::string& LineStyleName);
    virtual int SetLineStyle(int LineStyleIndex = 0, unsigned Offset = 0);
    virtual bool GetLineStyle(int LineStyleIndex, std::vector<int>& LineStyle);
    virtual int LoadFont(const std::string& FontName, int FontSize);
    virtual int SetFont(int FontIndex);
    virtual std::string SetTextAdjustment(const std::string& Adjustment);
    virtual int SetTextOrientation(int Digree);
    virtual int TextHeightOf(const std::string& Text);
    virtual int TextAscentOf(const std::string& Text);
    virtual int TextWidthOf(const std::string& Text);
    virtual TKinokoCanvasImage* LoadXpmImage(const std::string& FileName);
    virtual void DrawImage(float x, float y, TKinokoCanvasImage* Image);
  protected:
    float DeviceXOf(float x);
    float DeviceYOf(float y);
  protected:
    TKinokoCanvasImageArea* _PrimaryImageArea;
    std::ostream* _File;
    std::map<std::string, std::string> _PredefinedFontNameTable;
    std::map<int, TKinokoCanvasColor> _ColorTable;
    std::map<int, std::string> _LineStyleTable;
    std::map<int, std::pair<std::string, int> > _FontNameTable;
  protected:
    int _CurrentColorIndex;
    int _CurrentLineWidth;
    int _CurrentLineStyleIndex;
    int _CurrentFontIndex;
    int _CurrentTextOrientation;
  protected:
    TTextAdjustment _VerticalTextAdjustment;
    TTextAdjustment _HorizontalTextAdjustment;
};


#endif

