/* KinokoCanvasMarker.cc */
/* Created by Enomoto Sanshiro on 18 May 2002. */
/* Last updated by Enomoto Sanshiro on 18 May 2002. */


#include <string>
#include <map>
#include "KinokoCanvasImageArea.hh"
#include "KinokoCanvasMarker.hh"

using namespace std;


TKinokoCanvasMarker::TKinokoCanvasMarker(void)
{
}

TKinokoCanvasMarker::~TKinokoCanvasMarker()
{
}



TKinokoCanvasMarkerFactory::TKinokoCanvasMarkerFactory(void)
{
    _IsConstructed = false;
}

TKinokoCanvasMarkerFactory::~TKinokoCanvasMarkerFactory()
{
    map<string, TKinokoCanvasMarker*>::iterator MarkerEntry;
    for (
	MarkerEntry = _MarkerPrototypeTable.begin();
	MarkerEntry != _MarkerPrototypeTable.end();
	MarkerEntry++
    ){
	delete (*MarkerEntry).second;
    }
}

void TKinokoCanvasMarkerFactory::Construct(void)
{
    if (_IsConstructed) {
	return;
    }

    AddMarker("circle", new TKinokoCanvasCircleMarker());
    AddMarker("rectangle", new TKinokoCanvasRectangleMarker());
    AddMarker("triangle", new TKinokoCanvasTriangleMarker());
    AddMarker("diamond", new TKinokoCanvasDiamondMarker());

    AddMarker("xpm", new TKinokoCanvasXpmMarker());
}

void TKinokoCanvasMarkerFactory::AddMarker(const string& Name, TKinokoCanvasMarker* Marker)
{
    _MarkerPrototypeTable[Name] = Marker;
}

TKinokoCanvasMarker* TKinokoCanvasMarkerFactory::CreateMarker(const string& Name, const string& Parameter)
{
    if (! _IsConstructed) {
	Construct();
    }

    if (_MarkerPrototypeTable.find(Name) == _MarkerPrototypeTable.end()) {
	return 0;
    }

    return _MarkerPrototypeTable[Name]->Clone(Parameter);
}



TKinokoCanvasMarker* TKinokoCanvasCircleMarker::Clone(const string& Parameter)
{
    return new TKinokoCanvasCircleMarker();
}

void TKinokoCanvasCircleMarker::Draw(TKinokoCanvasImageArea* _ImageArea, float X, float Y, float Size)
{
    _ImageArea->DrawCircleFill(X, Y, Size);
}



TKinokoCanvasMarker* TKinokoCanvasRectangleMarker::Clone(const string& Parameter)
{
    return new TKinokoCanvasRectangleMarker();
}

void TKinokoCanvasRectangleMarker::Draw(TKinokoCanvasImageArea* _ImageArea, float X, float Y, float Size)
{
    _ImageArea->DrawRectFill(X - Size, Y - Size, X + Size, Y + Size);
}



TKinokoCanvasMarker* TKinokoCanvasTriangleMarker::Clone(const string& Parameter)
{
    return new TKinokoCanvasTriangleMarker();
}

void TKinokoCanvasTriangleMarker::Draw(TKinokoCanvasImageArea* _ImageArea, float X, float Y, float Size)
{
    vector<pair<float, float> > PointList;
    PointList.push_back(make_pair(X, Y - Size));
    PointList.push_back(make_pair(X - Size, Y + Size));
    PointList.push_back(make_pair(X + Size, Y + Size));

    _ImageArea->DrawPolygonFill(PointList);
}

TKinokoCanvasMarker* TKinokoCanvasDiamondMarker::Clone(const string& Parameter)
{
    return new TKinokoCanvasDiamondMarker();
}

void TKinokoCanvasDiamondMarker::Draw(TKinokoCanvasImageArea* _ImageArea, float X, float Y, float Size)
{
    vector<pair<float, float> > PointList;
    PointList.push_back(make_pair(X, Y - Size));
    PointList.push_back(make_pair(X - Size, Y));
    PointList.push_back(make_pair(X, Y + Size));
    PointList.push_back(make_pair(X + Size, Y));

    _ImageArea->DrawPolygonFill(PointList);
}



TKinokoCanvasXpmMarker::TKinokoCanvasXpmMarker(const string& ImageFileName)
{
    _ImageFileName = ImageFileName;

    _Image = 0;
    _HalfWidth = 0;
    _HalfHeight = 0;
}

TKinokoCanvasXpmMarker::~TKinokoCanvasXpmMarker()
{
}

TKinokoCanvasMarker* TKinokoCanvasXpmMarker::Clone(const string& Parameter)
{
    if (! Parameter.empty()) {
	return new TKinokoCanvasXpmMarker(Parameter);
    }
    else {
	return new TKinokoCanvasXpmMarker(_ImageFileName);
    }
}

void TKinokoCanvasXpmMarker::Draw(TKinokoCanvasImageArea* ImageArea, float X, float Y, float Size)
{
    if (_Image == 0) {
	_Image = ImageArea->LoadXpmImage(_ImageFileName);
	if (_Image != 0) {
	    _HalfWidth = _Image->Width() / 2;
	    _HalfHeight = _Image->Height() / 2;
	}
    }
    else {
	//...
    }

    if (_Image != 0) {
	ImageArea->DrawImage(X - _HalfWidth, Y - _HalfHeight, _Image);
    }
}
