/* KinokoCanvasObject.cc */
/* Created by Enomoto Sanshiro on 10 July 2000. */
/* Last updated by Enomoto Sanshiro on 8 April 2001. */


#include <iostream>
#include <string>
#include "KinokoCanvas.hh"
#include "KinokoCanvasImageArea.hh"
#include "KinokoCanvasObject.hh"

using namespace std;



TKinokoCanvasObject::TKinokoCanvasObject(TKinokoCanvas* Canvas, TKinokoCanvasImageArea* ImageArea)
{
    _Canvas = Canvas;
    _ImageArea = ImageArea;

    _OffsetX = 0;
    _OffsetY = 0;
    _Width = 0;
    _Height = 0;

    _ColorIndexList[Color_Foreground] = _ImageArea->AllocateColor("black");
    _ColorIndexList[Color_Background] = _ImageArea->AllocateColor("white");
    _ImageArea->SetColor(_ColorIndexList[Color_Foreground]);

    _FontIndexList[Font_Normal] = _ImageArea->LoadFont("times", 14);
    _FontIndexList[Font_Title] = _ImageArea->LoadFont("helvetica", 20);
    _FontIndexList[Font_Label] = _ImageArea->LoadFont("helvetica", 14);
    _ImageArea->SetFont(_FontIndexList[Font_Normal]);

    _LineHeight = (int) (1.2 * _ImageArea->TextHeightOf("ABCDEfghijklpq"));
}

TKinokoCanvasObject::~TKinokoCanvasObject()
{
}

int TKinokoCanvasObject::Construct(istream& InputStream)
{
    int Result = 1;

    float OffsetX, OffsetY, Width, Height;
    if (InputStream >> OffsetX >> OffsetY >> Width >> Height) {
	OffsetX = (OffsetX / 100) * _ImageArea->Width();
	OffsetY = (OffsetY / 100) * _ImageArea->Height();
	Width = (Width / 100) * _ImageArea->Width();
	Height = (Height / 100) * _ImageArea->Height();
	
	SetPosition((int) OffsetX, (int) OffsetY, (int) Width, (int) Height);
	_Canvas->AddCanvasObject(this);
    }
    else {
	Result = 0;
    }

    return Result;
}

void TKinokoCanvasObject::SetPosition(int OffsetX, int OffsetY, int Width, int Height)
{
    _OffsetX = OffsetX;
    _OffsetY = OffsetY;
    _Width = Width;
    _Height = Height;
}

bool TKinokoCanvasObject::Includes(int X, int Y)
{
    return (
	(X > _OffsetX) && (Y > _OffsetY) && 
	(X < _OffsetX + _Width) && (Y < _OffsetY + _Height)
    );
}

vector<string> TKinokoCanvasObject::ActionList(void)
{
    return vector<string>();
}
    
int TKinokoCanvasObject::ProcessAction(const string& ActionName)
{
    return 0;
}

void TKinokoCanvasObject::Clear(void)
{
    int OldColor = _ImageArea->SetColor(_ColorIndexList[Color_Background]);
    _ImageArea->DrawRectFill(
	_OffsetX, _OffsetY, _OffsetX + _Width, _OffsetY + _Height
    );
    _ImageArea->SetColor(OldColor);
}
