/* KinokoCanvasObject.hh */
/* Created by Enomoto Sanshiro on 10 July 2000. */
/* Last updated by Enomoto Sanshiro on 8 April 2001. */


#ifndef __KinokoCanvasObject_hh
#define __KinokoCanvasObject_hh


#include <iostream>
#include <string>
#include <map>
#include "KinokoCanvasImageArea.hh"
#include "KinokoShell.hh"


class TKinokoCanvas;


class TKinokoCanvasObject: public TKinokoShellObject {
  public:
    TKinokoCanvasObject(TKinokoCanvas* Canvas, TKinokoCanvasImageArea* ImageAre);
    virtual ~TKinokoCanvasObject();
    virtual int Construct(std::istream& InputStream);
    virtual void SetPosition(int OffsetX, int OffsetY, int Width, int Height);
    virtual bool Includes(int X, int Y);
    virtual std::vector<std::string> ActionList(void);
    virtual int ProcessAction(const std::string& ActionName);
    virtual void Clear(void);
  protected:
    TKinokoCanvas* _Canvas;
    TKinokoCanvasImageArea* _ImageArea;
    int _OffsetX, _OffsetY, _Width, _Height;    
    int _LineHeight;
  protected:
    enum TColorEnum {
	Color_Foreground,
	Color_Background,
	_NumberOfEnumColors
    };
    int _ColorIndexList[_NumberOfEnumColors];
  protected:
    enum TFontEnum {
	Font_Normal,
	Font_Title,
	Font_Label,
	_NumberOfEnumFonts
    };
    int _FontIndexList[_NumberOfEnumFonts];
};


#endif
