/* KinokoCanvasPlotObject.hh */
/* Created by Enomoto Sanshiro on 11 July 2000. */
/* Last updated by Enomoto Sanshiro on 9 January 2002. */


#ifndef __KinokoCanvasPlotObject_hh
#define __KinokoCanvasPlotObject_hh


#include <string>
#include <iostream>
#include "KinokoCanvasDataScale.hh"
#include "KinokoCanvasColorScale.hh"
#include "KinokoCanvasMarker.hh"
#include "KinokoCanvasFramedObject.hh"


class TKinokoCanvasPlotObject: virtual public TKinokoCanvasFramedObject {
  public:
    TKinokoCanvasPlotObject(TKinokoCanvas* Canvas, TKinokoCanvasImageArea* ImageArea);
    virtual ~TKinokoCanvasPlotObject();
    virtual TKinokoShellObject* Clone(void);
    virtual std::vector<std::string> ActionList(void);
    virtual int ProcessAction(const std::string& ActionName);
  protected:
    virtual int ProcessCommand(const std::string& Command, std::istream& InputStream);
    virtual int ProcessSetCommand(const std::string& Name, const std::string& Value);
    virtual int ProcessPlotCommand(std::istream& InputStream, const std::string& Style);
    virtual int ProcessErrorPlotCommand(std::istream& InputStream);
    virtual int ProcessMinmaxPlotCommand(std::istream& InputStream);
    virtual int ProcessHistCommand(std::istream& InputStream);
    virtual int ProcessCommentCommand(std::istream& InputStream);
    virtual int ProcessWriteXScaleLabelCommand(std::istream& InputStream);
    virtual int ProcessWriteYScaleLabelCommand(std::istream& InputStream);
  protected:
    virtual float CanvasXOf(float x);
    virtual float CanvasYOf(float y);
    virtual int SetCoordinate(float XMin, float YMin, float XWidth, float YWidth);
    virtual int SetXScaleLinear(void);
    virtual int SetXScaleLog(void);
    virtual int SetYScaleLinear(void);
    virtual int SetYScaleLog(void);
    virtual int SaveContext(void);
    virtual int RestoreContext(void);
  protected:
    virtual int SetMarker(std::string MarkerName);
    virtual int SetMarkerSize(const std::string& SizeString);
    virtual int DrawFrame(void);
  protected:
    TKinokoCanvasDataScale *_XScale, *_YScale;
    bool _IsXScaleLabelDisabled, _IsYScaleLabelDisabled;
    bool _IsXScaleLog, _IsYScaleLog;
    float _LogXMin, _LogXMax, _LogYMin, _LogYMax;
    float _LogXWidth, _LogYWidth;
    float _XMinOrg, _XWidthOrg, _YMinOrg, _YWidthOrg;
    std::string _XTitle, _YTitle;
    bool _IsYTitleVertical;
    TKinokoCanvasMarkerFactory *_MarkerFactory;
    TKinokoCanvasMarker *_Marker;
    int _MarkerSize;
  private:
    std::deque<TKinokoCanvasMarker*> _MarkerStack;
    std::deque<int> _MarkerSizeStack;
};


class TKinokoCanvasMapPlotObject: public TKinokoCanvasColorScaledObject {
  public:
    TKinokoCanvasMapPlotObject(TKinokoCanvas* Canvas, TKinokoCanvasImageArea* ImageArea);
    virtual ~TKinokoCanvasMapPlotObject();
    virtual TKinokoShellObject* Clone(void);
  protected:
    virtual float CanvasXOf(float x);
    virtual float CanvasYOf(float y);
    virtual int ProcessCommand(const std::string& Command, std::istream& InputStream);
    virtual int ProcessPlotCommand(std::istream& InputStream);    
  protected:
    virtual int DrawFrame(void);
};


#endif

