/* KinokoCanvasTextBoxObject.cc */
/* Created by Enomoto Sanshiro on 23 January 2001. */
/* Last updated by Enomoto Sanshiro on 23 January 2001. */


#include <strstream>
#include "KinokoCanvasFramedObject.hh"
#include "KinokoCanvasTextBoxObject.hh"

using namespace std;


TKinokoCanvasTextBoxObject::TKinokoCanvasTextBoxObject(TKinokoCanvas* Canvas, TKinokoCanvasImageArea* ImageArea)
: TKinokoCanvasFramedObject(Canvas, ImageArea)
{
    _CurrentX = 0;
    _CurrentY = 0;
    _CurrentColumn = 0;

    _NumberOfColumns = 1;
}

TKinokoCanvasTextBoxObject::~TKinokoCanvasTextBoxObject()
{
}

TKinokoShellObject* TKinokoCanvasTextBoxObject::Clone(void)
{
    return new TKinokoCanvasTextBoxObject(_Canvas, _ImageArea);
}

int TKinokoCanvasTextBoxObject::ProcessCommand(const string& Command, istream& InputStream)
{
    int Result = 0;

    if (Command == "write") {
	Result = ProcessWriteCommand(InputStream);
    }
    else {
	Result = TKinokoCanvasFramedObject::ProcessCommand(Command, InputStream);
    }

    return Result;
}

int TKinokoCanvasTextBoxObject::ProcessSetCommand(const string& Name, const string& Value)
{
    int Result = 0;

    if (Name == "columns") {
	istrstream ValueStream(Value.c_str());
	_NumberOfColumns = 0;
	ValueStream >> _NumberOfColumns;
	if (_NumberOfColumns > 0) {
	    Result = 1;
	}
    }
    else {
	Result = TKinokoCanvasFramedObject::ProcessSetCommand(Name, Value);
    }

    return Result;
}

int TKinokoCanvasTextBoxObject::ProcessWriteCommand(istream& InputStream)
{
    if (! _IsFrameValid) {
	return 1;
    }

    int Result = 0;

    string OldTextAdjustment = _ImageArea->SetTextAdjustment("bl");
    int OldFontIndex = _ImageArea->SetFont(_FontIndex);
    int OldColorIndex = _ImageArea->SetColor(_ColorIndex);

    string Line;
    InputStream >> ws;
    while (getline(InputStream, Line, '\n')) {
	if (_CurrentColumn >= _NumberOfColumns) {
	    break;
	}

	_CurrentY += _LineHeight;
	if (_CurrentY > _FrameHeight) {
	    _CurrentColumn++;
	    _CurrentX = _FrameWidth / _NumberOfColumns * _CurrentColumn;
	    _CurrentY = _LineHeight;
	    if (_CurrentColumn >= _NumberOfColumns) {
		break;
	    }
	}

	int x = _OffsetX + _LeftMargin + _CurrentX;
	int y = _OffsetY + _TopMargin + _CurrentY;

	_ImageArea->DrawText(x, y, Line);

	Result = 1;
    }

    _ImageArea->SetTextAdjustment(OldTextAdjustment);
    _ImageArea->SetFont(OldFontIndex);
    _ImageArea->SetColor(OldColorIndex);

    return Result;
}

void TKinokoCanvasTextBoxObject::Clear(void)
{
    _CurrentX = 0;
    _CurrentY = 0;
    _CurrentColumn = 0;

    TKinokoCanvasObject::Clear();
}

int TKinokoCanvasTextBoxObject::SetTitle(const std::string& Title)
{
    int Result = TKinokoCanvasFramedObject::SetTitle(Title);
    DrawFrame();
    
    return Result;
}
