/* KinokoCanvasTextBoxObject.hh */
/* Created by Enomoto Sanshiro on 23 January 2001. */
/* Last updated by Enomoto Sanshiro on 23 January 2001. */


#ifndef __KinokoCanvasTextBoxObject_hh
#define __KinokoCanvasTextBoxObject_hh


#include <iostream>
#include <string>
#include "KinokoCanvasFramedObject.hh"


class TKinokoCanvasTextBoxObject: public TKinokoCanvasFramedObject {
  public:
    TKinokoCanvasTextBoxObject(TKinokoCanvas* Canvas, TKinokoCanvasImageArea* ImageArea);
    virtual ~TKinokoCanvasTextBoxObject();
    virtual TKinokoShellObject* Clone(void);
    virtual void Clear(void);
  protected:
    virtual int ProcessCommand(const std::string& Command, std::istream& InputStream);
    virtual int ProcessSetCommand(const std::string& Name, const std::string& Value);
    virtual int ProcessWriteCommand(std::istream& InputStream);
  protected:
    virtual int SetTitle(const std::string& Title);
  protected:
    int _CurrentX, _CurrentY;
    int _NumberOfColumns, _CurrentColumn;
};


#endif
