/* KinokoControl.hh */
/* Created by Enomoto Sanshiro on 1 October 2001. */
/* Last updated by Enomoto Sanshiro on 27 March 2002. */


#ifndef __KinokoControl_hh
#define __KinokoControl_hh


#include <string>
#include <vector>
#include <map>
#include <set>
#include "KinokoShell.hh"
#include "KinokoShellScript.hh"
#include "KinokoControlWidget.hh"
#include "KinokoControlPanel.hh"

class TKinokoControlScript;


class TKinokoControl: public TKinokoShell {
  public:
    TKinokoControl(TKinokoShellConnector* ShellConnector);
    virtual ~TKinokoControl();
    virtual void Start(void) = 0;
    virtual void Quit(void) = 0;
    virtual void AddWidget(TKinokoControlWidget* Widget, const std::string& EnabledStateList = "");
    virtual void AddInputWidget(TKinokoControlWidget* Widget);
    virtual void OnClickWidget(TKinokoControlWidget* Widget);
    virtual void ReadScript(const std::string& ScriptText);
    virtual void AddActionScript(const std::string& Name, const std::string& ActionScriptText);
  public:
    virtual void Construct(const std::string& ScriptFileName) = 0;
    virtual void SetValue(const std::string& WidgetName, const std::string& Value);
    virtual void ChangeState(const std::string& StateName);
    virtual int ClearValues(void);
    virtual int SaveValuesTo(const std::string& FileName);
    virtual int LoadValuesFrom(const std::string& FileName);
    virtual TKinokoControlWidget* LookupWidget(const std::string& WidgetName);
  protected:
    virtual void Invoke(const std::string& MethodName);
    virtual int ExecuteAction(const std::string& ActionName);
    virtual int ProcessSystemCommand(const std::string& Command, std::istream& InputStream);
    virtual int ProcessOpenCommand(std::istream& InputStream);
    virtual int ProcessClearCommand(std::istream& InputStream);
    virtual int ProcessSaveCommand(std::istream& InputStream);
    virtual int ProcessLoadCommand(std::istream& InputStream);
    virtual int ProcessSetCommand(std::istream& InputStream);
    virtual int ProcessExecuteCommand(std::istream& InputStream);
    virtual int ProcessChangeStateCommand(std::istream& InputStream);
    virtual int ProcessOpenPopupCommand(std::istream& InputStream, bool IsQuery);
    virtual std::string ReplaceEscape(const std::string& Value);
  protected:
    std::map<std::string, TKinokoControlWidget*> _WidgetTable; 
    std::vector<TKinokoControlWidget*> _InputWidgetList; 
    std::vector<std::string> _InputValueCache;
    std::map<TKinokoControlWidget*, std::set<std::string> > _EnabledStateList;
    std::map<std::string, TKinokoControlScript*> _ActionScriptTable;
    TKinokoControlScript* _Script;
    TKinokoShellScript* _ShellScript;
};


#endif
