/* KinokoControlPanel.hh */
/* Created by Enomoto Sanshiro on 27 September 2001. */
/* Last updated by Enomoto Sanshiro on 27 September 2001. */


#ifndef __KinokoControlPanel_hh
#define __KinokoControlPanel_hh


#include <string>
#include <map>
#include "KinokoControlWidget.hh"


class TKinokoControl;


class TKinokoControlPanel {
  public:
    TKinokoControlPanel(TKinokoControl* Control, const std::string& RootPath = "");
    virtual ~TKinokoControlPanel();
    virtual void OpenPanel(std::map<std::string, std::string>& OptionTable) = 0;
    virtual void ClosePanel(void) = 0;
    virtual void OpenFrame(std::map<std::string, std::string>& OptionTable) = 0;
    virtual void CloseFrame(void) = 0;
    virtual void OpenBox(std::map<std::string, std::string>& OptionTable) = 0;
    virtual void CloseBox(void) = 0;
    virtual void OpenToolBar(std::map<std::string, std::string>& OptionTable) = 0;
    virtual void CloseToolBar(void) = 0;
    virtual void OpenEntryList(std::map<std::string, std::string>& OptionTable) = 0;
    virtual void CloseEntryList(void) = 0;
    virtual void AddEntry(std::map<std::string, std::string>& OptionTable) = 0;
    virtual void OpenButtonList(std::map<std::string, std::string>& OptionTable) = 0;
    virtual void CloseButtonList(void) = 0;
    virtual void AddButton(std::map<std::string, std::string>& OptionTable) = 0;
    virtual void OpenCheckButtonList(std::map<std::string, std::string>& OptionTable) = 0;
    virtual void CloseCheckButtonList(void) = 0;
    virtual void AddCheckButton(std::map<std::string, std::string>& OptionTable) = 0;
    virtual void OpenRadioButtonList(std::map<std::string, std::string>& OptionTable) = 0;
    virtual void CloseRadioButtonList(void) = 0;
    virtual void AddRadioButton(std::map<std::string, std::string>& OptionTable) = 0;
    virtual void OpenMenu(std::map<std::string, std::string>& OptionTable) = 0;
    virtual void CloseMenu(void) = 0;
    virtual void AddMenuItem(std::map<std::string, std::string>& OptionTable) = 0;
    virtual void AddLabel(std::map<std::string, std::string>& OptionTable) = 0;
    virtual void AddImage(std::map<std::string, std::string>& OptionTable) = 0;
    virtual void AddTextBox(std::map<std::string, std::string>& OptionTable) = 0;
    virtual void VSpace(std::map<std::string, std::string>& OptionTable) = 0;
    virtual void HSpace(std::map<std::string, std::string>& OptionTable) = 0;
    virtual void NewLine(std::map<std::string, std::string>& OptionTable) = 0;
    virtual void ReadScript(const std::string& Script);
    virtual void BeginAction(std::map<std::string, std::string>& OptionTable);
    virtual void EndAction(const std::string& ActionScript);
  protected:
    TKinokoControl* _Control;
    std::string _RootPath;
    std::string _CurrentActionName;
};


#endif
