/* KinokoControlPanelScript.cc */
/* Created by Enomoto Sanshiro on 28 September 2001. */
/* Last updated by Enomoto Sanshiro on 28 September 2001. */


#include <iostream>
#include <string>
#include "KinokoControlPanel.hh"
#include "KinokoControlPanelScript.hh"


using namespace std;


TKinokoControlPanelScript::TKinokoControlPanelScript(TKinokoControlPanel* ControlPanel, const string& ScriptFileName)
{
    _ControlPanel = ControlPanel;
    _ScriptFileName = ScriptFileName;
    _ReadsCommentCharacter = false;
}


TKinokoControlPanelScript::~TKinokoControlPanelScript()
{
}

void TKinokoControlPanelScript::OnStartWidget(const string& WidgetTypeName, map<string, string>& OptionTable)
{
    _TextStack.push_back(_CurrentText);
    _CurrentText.erase(_CurrentText.begin(), _CurrentText.end());

    if (WidgetTypeName == "kinokocontrolpanel") {
	_ControlPanel->OpenPanel(OptionTable);
    }
    else if (WidgetTypeName == "frame") {
	_ControlPanel->OpenFrame(OptionTable);
    }
    else if (WidgetTypeName == "box") {
	_ControlPanel->OpenBox(OptionTable);
    }
    else if (WidgetTypeName == "toolbar") {
	_ControlPanel->OpenToolBar(OptionTable);
    }
    else if (WidgetTypeName == "entrylist") {
	_ControlPanel->OpenEntryList(OptionTable);
    }
    else if (WidgetTypeName == "entry") {
	_ControlPanel->AddEntry(OptionTable);
    }
    else if (WidgetTypeName == "buttonlist") {
	_ControlPanel->OpenButtonList(OptionTable);
    }
    else if (WidgetTypeName == "button") {
	_ControlPanel->AddButton(OptionTable);
    }
    else if (WidgetTypeName == "checkbuttonlist") {
	_ControlPanel->OpenCheckButtonList(OptionTable);
    }
    else if (WidgetTypeName == "checkbutton") {
	_ControlPanel->AddCheckButton(OptionTable);
    }
    else if (WidgetTypeName == "radiobuttonlist") {
	_ControlPanel->OpenRadioButtonList(OptionTable);
    }
    else if (WidgetTypeName == "radiobutton") {
	_ControlPanel->AddRadioButton(OptionTable);
    }
    else if (WidgetTypeName == "menu") {
	_ControlPanel->OpenMenu(OptionTable);
    }
    else if (WidgetTypeName == "menuitem") {
	_ControlPanel->AddMenuItem(OptionTable);
    }
    else if (WidgetTypeName == "label") {
	_ControlPanel->AddLabel(OptionTable);
    }
    else if (WidgetTypeName == "textbox") {
	_ControlPanel->AddTextBox(OptionTable);
    }
    else if (WidgetTypeName == "image") {
	_ControlPanel->AddImage(OptionTable);
    }
    else if ((WidgetTypeName == "newline") || (WidgetTypeName == "p")) {
	_ControlPanel->NewLine(OptionTable);
    }
    else if (WidgetTypeName == "vspace") {
	_ControlPanel->VSpace(OptionTable);
    }
    else if (WidgetTypeName == "hspace") {
	_ControlPanel->HSpace(OptionTable);
    }
    else if (WidgetTypeName == "script") {
	_ReadsCommentCharacter = true;
    }
#if 1
    //... for backward compatibility ...//
    else if (WidgetTypeName == "action") {
	_ControlPanel->BeginAction(OptionTable);
	_ReadsCommentCharacter = true;
    }
#endif
}

void TKinokoControlPanelScript::OnEndWidget(const string& WidgetTypeName)
{
    if (WidgetTypeName == "kinokocontrolpanel") {
	_ControlPanel->ClosePanel();
    }
    else if (WidgetTypeName == "frame") {
	_ControlPanel->CloseFrame();
    }
    else if (WidgetTypeName == "box") {
	_ControlPanel->CloseBox();
    }
    else if (WidgetTypeName == "toolbar") {
	_ControlPanel->CloseToolBar();
    }
    else if (WidgetTypeName == "entrylist") {
	_ControlPanel->CloseEntryList();
    }
    else if (WidgetTypeName == "buttonlist") {
	_ControlPanel->CloseButtonList();
    }
    else if (WidgetTypeName == "checkbuttonlist") {
	_ControlPanel->CloseCheckButtonList();
    }
    else if (WidgetTypeName == "radiobuttonlist") {
	_ControlPanel->CloseRadioButtonList();
    }
    else if (WidgetTypeName == "menu") {
	_ControlPanel->CloseMenu();
    }
    else if (WidgetTypeName == "script") {
	_ControlPanel->ReadScript(_CurrentText);
	_ReadsCommentCharacter = false;
    }
#if 1
    //... for backward compatibility ...//
    else if (WidgetTypeName == "action") {
	_ControlPanel->EndAction(_CurrentText);
	_ReadsCommentCharacter = false;
    }
#endif

    if (! _TextStack.empty()) {
	_CurrentText = _TextStack.back();
	_TextStack.pop_back();
    }
}

void TKinokoControlPanelScript::OnCharacter(char Character)
{
    _CurrentText += Character;
}

void TKinokoControlPanelScript::OnCommentCharacter(char Character)
{
    if (_ReadsCommentCharacter) {
	_CurrentText += Character;
    }
}

void TKinokoControlPanelScript::OnScriptError(const string& Message)
{
    cerr << "ERROR: " << Message << endl;
}
