/* KinokoControlPanelScript.hh */
/* Created by Enomoto Sanshiro on 28 September 2001. */
/* Last updated by Enomoto Sanshiro on 28 September 2001. */


#ifndef __KinokoControlPanelScript_hh
#define __KinokoControlPanelScript_hh


#include <string>
#include <map>
#include <deque>
#include "KinokoControlPanel.hh"


class TKinokoControlPanelScript {
  public:
    TKinokoControlPanelScript(TKinokoControlPanel* ControlPanel, const std::string& ScriptFileName);
    virtual ~TKinokoControlPanelScript();
    virtual void Go(void) = 0;
  public:
    virtual void OnStartWidget(const std::string& WidgetTypeName, std::map<std::string, std::string>& OptionTable);
    virtual void OnEndWidget(const std::string& WidgetTypeName);
    virtual void OnCharacter(char Character);
    virtual void OnCommentCharacter(char Character);
    virtual void OnScriptError(const std::string& Message);
  protected:
    TKinokoControlPanel* _ControlPanel;
    std::string _ScriptFileName;
    std::string _CurrentText;
    std::deque<std::string> _TextStack;
    bool _ReadsCommentCharacter;
};


#endif
