/* KinokoControlScript.cc */
/* Created by Enomoto Sanshiro on 25 October 2002. */
/* Last updated by Enomoto Sanshiro on 25 October 2002. */


#include "ParaParser.hh"
#include "KinokoControl.hh"
#include "KinokoControlScript.hh"

using namespace std;


TKinokoControlScript::TKinokoControlScript(TKinokoControl* Control)
{
    _Control = Control;
}

TKinokoControlScript::~TKinokoControlScript()
{
}

TParaTokenTable* TKinokoControlScript::CreateTokenTable(void)
{
    TParaTokenTable* TokenTable = TParaStandardParser::CreateTokenTable();

    TokenTable->AddKeyword("exit");

    return TokenTable;
}

TParaOperatorTable* TKinokoControlScript::CreateOperatorTable(void)
{
    return TParaStandardParser::CreateOperatorTable();
}

TParaStatementTable* TKinokoControlScript::CreateStatementTable(void)
{
    TParaStatementTable* StatementTable;
    StatementTable = TParaStandardParser::CreateStatementTable();

    StatementTable->AddStatement(new TKinokoControlExitStatement(_Control));

    return StatementTable;
}

TParaPackage* TKinokoControlScript::CreatePackage(void)
{
    TParaPackage* Package = TParaStandardParser::CreatePackage();

    return Package;
}

TParaObjectPrototypeTable* TKinokoControlScript::CreateObjectPrototypeTable(void)
{
    TParaObjectPrototypeTable* ObjectPrototypeTable;
    ObjectPrototypeTable = TParaStandardParser::CreateObjectPrototypeTable();

    return ObjectPrototypeTable;
}

TParaBuiltinFunctionTable* TKinokoControlScript::CreateBuiltinFunctionTable(void)
{
    TParaBuiltinFunctionTable* BuiltinFunctionTable;
    BuiltinFunctionTable = TParaStandardParser::CreateBuiltinFunctionTable();

    BuiltinFunctionTable->RegisterAnonymousClass(
	new TKinokoControlPanelMessenger(_Control)
    );

    return BuiltinFunctionTable;
}



TKinokoControlPanelMessenger::TKinokoControlPanelMessenger(TKinokoControl* Control)
: TParaObjectPrototype("ControlPanel")
{
    _Control = Control;
}

TKinokoControlPanelMessenger::~TKinokoControlPanelMessenger()
{
}

TKinokoControlPanelMessenger* TKinokoControlPanelMessenger::Clone(void)
{
    return new TKinokoControlPanelMessenger(_Control);
}

void TKinokoControlPanelMessenger::Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException)
{
}

void TKinokoControlPanelMessenger::Destruct(void) throw(TScriptException)
{
}

int TKinokoControlPanelMessenger::MethodIdOf(const std::string& MethodName)
{
    if (MethodName == "clearWidgetValues") {
        return MethodId_ClearWidgetValues;
    }
    else if (MethodName == "loadWidgetValues") {
        return MethodId_LoadWidgetValues;
    }
    else if (MethodName == "saveWidgetValues") {
        return MethodId_SaveWidgetValues;
    }
    else if (MethodName == "lookupWidget") {
        return MethodId_LookupWidget;
    }

    return TParaObjectPrototype::MethodIdOf(MethodName);
}

int TKinokoControlPanelMessenger::InvokeMethod(int MethodId, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException)
{
    int Result = 0;

    switch (MethodId) {
      case MethodId_ClearWidgetValues:
        Result = ClearWidgetValues(ArgumentList, ReturnValue);
	break;
      case MethodId_LoadWidgetValues:
        Result = LoadWidgetValues(ArgumentList, ReturnValue);
	break;
      case MethodId_SaveWidgetValues:
        Result = SaveWidgetValues(ArgumentList, ReturnValue);
	break;
      case MethodId_LookupWidget:
        Result = LookupWidget(ArgumentList, ReturnValue);
	break;
      default:
	Result = 0;
    }
    
    return Result;
}

int TKinokoControlPanelMessenger::ClearWidgetValues(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException)
{
    ReturnValue = TParaValue((long) _Control->ClearValues());

    return 1;
}

int TKinokoControlPanelMessenger::LoadWidgetValues(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException)
{
    if ((ArgumentList.size() < 1) || (! ArgumentList[0]->IsString())) {
	throw TScriptException(
	    "ControlPanel::loadWidgetValues(string file_name)", 
	    "invalid argument[s]"
	);
    }

    string FileName = ArgumentList[0]->AsString();
    ReturnValue = TParaValue((long) _Control->LoadValuesFrom(FileName));

    return 1;
}

int TKinokoControlPanelMessenger::SaveWidgetValues(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException)
{
    if ((ArgumentList.size() < 1) || (! ArgumentList[0]->IsString())) {
	throw TScriptException(
	    "ControlPanel::saveWidgetValues(string file_name)", 
	    "invalid argument[s]"
	);
    }

    string FileName = ArgumentList[0]->AsString();
    ReturnValue = TParaValue((long) _Control->SaveValuesTo(FileName));

    return 1;
}

int TKinokoControlPanelMessenger::LookupWidget(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException)
{
    if ((ArgumentList.size() < 1) || (! ArgumentList[0]->IsString())) {
	throw TScriptException(
	    "ControlPanel::lookupWidget(string widget_name)", 
	    "invalid argument[s]"
	);
    }

    string WidgetName = ArgumentList[0]->AsString();
    TKinokoControlWidget* ControlWidget = _Control->LookupWidget(WidgetName);
    
    if (ControlWidget == 0) {
	throw TScriptException(
	    "ControlPanel::lookupWidget(string widget_name)", 
	    "unable to find widget: " + WidgetName
	);
    }

    ReturnValue = TParaValue(new TKinokoControlWidgetMessenger(ControlWidget));

    return 1;
}



TKinokoControlWidgetMessenger::TKinokoControlWidgetMessenger(TKinokoControlWidget* ControlWidget)
: TParaObjectPrototype("ControlWidget")
{
    _ControlWidget = ControlWidget;
}

TKinokoControlWidgetMessenger::~TKinokoControlWidgetMessenger()
{
}

TKinokoControlWidgetMessenger* TKinokoControlWidgetMessenger::Clone(void)
{
    // object duplication is prohibited.
    return 0;
}

void TKinokoControlWidgetMessenger::Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException)
{
}

void TKinokoControlWidgetMessenger::Destruct(void) throw(TScriptException)
{
}

int TKinokoControlWidgetMessenger::MethodIdOf(const std::string& MethodName)
{
    if (MethodName == "setValue") {
        return MethodId_SetValue;
    }
    else if (MethodName == "getValue") {
        return MethodId_GetValue;
    }
    else if (MethodName == "enable") {
        return MethodId_Enable;
    }
    else if (MethodName == "disable") {
        return MethodId_Disable;
    }

    return TParaObjectPrototype::MethodIdOf(MethodName);
}

int TKinokoControlWidgetMessenger::InvokeMethod(int MethodId, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException)
{
    int Result = 0;

    switch (MethodId) {
      case MethodId_SetValue:
        Result = SetValue(ArgumentList, ReturnValue);
	break;
      case MethodId_GetValue:
        Result = GetValue(ArgumentList, ReturnValue);
	break;
      case MethodId_Enable:
        Result = Enable(ArgumentList, ReturnValue);
	break;
      case MethodId_Disable:
        Result = Disable(ArgumentList, ReturnValue);
	break;
      default:
	Result = 0;
    }
    
    return Result;
}

int TKinokoControlWidgetMessenger::SetValue(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException)
{
    if (ArgumentList.size() < 1) {
	throw TScriptException(
	    "ControlWidget::setValue(string value)", "too few argument[s]"
	);
    }

    string Value = ArgumentList[0]->AsString();
    _ControlWidget->SetValue(Value);

    return 1;
}

int TKinokoControlWidgetMessenger::GetValue(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException)
{
    ReturnValue = TParaValue(_ControlWidget->Value());
    return 1;
}

int TKinokoControlWidgetMessenger::Enable(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException)
{
    _ControlWidget->Enable();
    return 1;
}

int TKinokoControlWidgetMessenger::Disable(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException)
{
    _ControlWidget->Disable();
    return 1;
}



TKinokoControlExitStatement::TKinokoControlExitStatement(TKinokoControl* Control)
{
    _Control = Control;
}

TKinokoControlExitStatement::~TKinokoControlExitStatement()
{
}

TParaStatement* TKinokoControlExitStatement::Clone(void)
{
    return new TKinokoControlExitStatement(_Control);
}

string TKinokoControlExitStatement::FirstToken(void) const
{
    return "exit";
}

void TKinokoControlExitStatement::Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException)
{
    Tokenizer->Next().MustBe("exit");
    Tokenizer->Next().MustBe(";");
}

TParaStatement::TExecResult TKinokoControlExitStatement::Execute(TParaSymbolTable* SymbolTable) throw(TScriptException)
{
    _Control->TryToQuit();

    TExecResult Result;
    Result.ExecStatus = TParaStatement::esReturn;

    return Result;
}
