/* KinokoControlScript.hh */
/* Created by Enomoto Sanshiro on 25 October 2002. */
/* Last updated by Enomoto Sanshiro on 25 October 2002. */


#ifndef __KinokoControlScript_hh__
#define __KinokoControlScript_hh__


#include "ParaParser.hh"
#include "KinokoControl.hh"


class TKinokoControlScript: public TParaStandardParser {
  public:
    TKinokoControlScript(TKinokoControl* Control);
    virtual ~TKinokoControlScript();
  protected:
    virtual TParaObjectPrototypeTable* CreateObjectPrototypeTable(void);
    virtual TParaBuiltinFunctionTable* CreateBuiltinFunctionTable(void);
    virtual TParaTokenTable* CreateTokenTable(void);
    virtual TParaOperatorTable* CreateOperatorTable(void);
    virtual TParaStatementTable* CreateStatementTable(void);
    virtual TParaPackage* CreatePackage(void);
  protected:
    TKinokoControl* _Control;
};


class TKinokoControlWidgetMessenger: public TParaObjectPrototype {
  public:
    TKinokoControlWidgetMessenger(TKinokoControlWidget* ControlWidget);
    virtual ~TKinokoControlWidgetMessenger();
    virtual TKinokoControlWidgetMessenger* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual void Destruct(void) throw(TScriptException);
    virtual int MethodIdOf(const std::string& MethodName);
    virtual int InvokeMethod(int MethodId, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    int SetValue(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int GetValue(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int Enable(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int Disable(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    enum {
	MethodId_SetValue = TParaObjectPrototype::_NumberOfMethods,
	MethodId_GetValue,
	MethodId_Enable,
	MethodId_Disable,
	_NumberOfMethods
    };
  protected:
    TKinokoControlWidget* _ControlWidget;
};


class TKinokoControlPanelMessenger: public TParaObjectPrototype {
  public:
    TKinokoControlPanelMessenger(TKinokoControl* Control);
    virtual ~TKinokoControlPanelMessenger();
    virtual TKinokoControlPanelMessenger* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual void Destruct(void) throw(TScriptException);
    virtual int MethodIdOf(const std::string& MethodName);
    virtual int InvokeMethod(int MethodId, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    int ClearWidgetValues(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int LoadWidgetValues(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int SaveWidgetValues(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int LookupWidget(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    enum {
	MethodId_ClearWidgetValues = TParaObjectPrototype::_NumberOfMethods,
	MethodId_LoadWidgetValues,
	MethodId_SaveWidgetValues,
	MethodId_LookupWidget,
	_NumberOfMethods
    };
  protected:
    TKinokoControl* _Control;
};


class TKinokoControlExitStatement: public TParaStatement {
  public:
    TKinokoControlExitStatement(TKinokoControl* Control);
    virtual ~TKinokoControlExitStatement();
    virtual TParaStatement* Clone(void);
    virtual std::string FirstToken(void) const;
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TExecResult Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TKinokoControl* _Control; 
    TParaStatementParser* _StatementParser;
};


#endif
