/* KinokoControlWidget.cc */
/* Created by Enomoto Sanshiro on 30 September 2001. */
/* Last updated by Enomoto Sanshiro on 30 September 2001. */


#include <string>
#include <vector>
#include "KinokoControlWidget.hh"

using namespace std;



TKinokoControlWidget::TKinokoControlWidget(const string& Name)
{
    _Name = Name;
}

TKinokoControlWidget::~TKinokoControlWidget()
{
}

string TKinokoControlWidget::Name(void)
{
    return _Name;
}

string TKinokoControlWidget::ActionOnClick(void)
{
    return _ActionOnClick;
}



TKinokoButtonWidget::TKinokoButtonWidget(const string& Name, const string& ActionOnClick)
: TKinokoControlWidget(Name)
{
    _ActionOnClick = ActionOnClick;
}

TKinokoButtonWidget::~TKinokoButtonWidget()
{
}

string TKinokoButtonWidget::Value(void)
{
    return "";
}

void TKinokoButtonWidget::SetValue(const string& Value)
{
}



TKinokoLabelWidget::TKinokoLabelWidget(const string& Name)
: TKinokoControlWidget(Name)
{
}

TKinokoLabelWidget::~TKinokoLabelWidget()
{
}


TKinokoEntryWidget::TKinokoEntryWidget(const string& Name)
: TKinokoControlWidget(Name)
{
}

TKinokoEntryWidget::~TKinokoEntryWidget()
{
}


TKinokoTextBoxWidget::TKinokoTextBoxWidget(const string& Name)
: TKinokoControlWidget(Name)
{
}

TKinokoTextBoxWidget::~TKinokoTextBoxWidget()
{
}


TKinokoCheckButtonWidget::TKinokoCheckButtonWidget(const string& Name)
: TKinokoControlWidget(Name)
{
}

TKinokoCheckButtonWidget::~TKinokoCheckButtonWidget()
{
}


TKinokoRadioButtonWidget::TKinokoRadioButtonWidget(const string& Name)
: TKinokoControlWidget(Name)
{
}

TKinokoRadioButtonWidget::~TKinokoRadioButtonWidget()
{
}


TKinokoRadioButtonSetWidget::TKinokoRadioButtonSetWidget(const string& Name)
: TKinokoControlWidget(Name)
{
}

TKinokoRadioButtonSetWidget::~TKinokoRadioButtonSetWidget()
{
    for (unsigned i = 0; i < _RadioButtonList.size(); i++) {
	delete _RadioButtonList[i];
    }
}

void TKinokoRadioButtonSetWidget::AddRadioButton(TKinokoRadioButtonWidget* RadioButtonWidget)
{
    _RadioButtonList.push_back(RadioButtonWidget);
    _RadioButtonTable[RadioButtonWidget->Name()] = RadioButtonWidget;
}

string TKinokoRadioButtonSetWidget::Value(void)
{
    string Result;
    for (unsigned i = 0; i < _RadioButtonList.size(); i++) {
	if (_RadioButtonList[i]->Value() == "1") {
	    Result = _RadioButtonList[i]->Name();
	    break;
	}
    }

    return Result;
}

void TKinokoRadioButtonSetWidget::SetValue(const string& Value)
{
    if (_RadioButtonTable.count(Value) > 0) {
	_RadioButtonTable[Value]->SetValue("1");
    }
}

void TKinokoRadioButtonSetWidget::Enable(void)
{
    for (unsigned i = 0; i < _RadioButtonList.size(); i++) {
	_RadioButtonList[i]->Disable();
    }
}

void TKinokoRadioButtonSetWidget::Disable(void)
{
    for (unsigned i = 0; i < _RadioButtonList.size(); i++) {
	_RadioButtonList[i]->Disable();
    }
}



TKinokoMenuItemWidget::TKinokoMenuItemWidget(const string& Name, const string& ActionOnClick)
: TKinokoControlWidget(Name)
{
    _ActionOnClick = ActionOnClick;
}

TKinokoMenuItemWidget::~TKinokoMenuItemWidget()
{
}

string TKinokoMenuItemWidget::Value(void)
{
    return "";
}

void TKinokoMenuItemWidget::SetValue(const string& Value)
{
}
