/* KinokoControlWidget.hh */
/* Created by Enomoto Sanshiro on 30 September 2001. */
/* Last updated by Enomoto Sanshiro on 30 September 2001. */


#ifndef __KinokoControlWidget_hh
#define __KinokoControlWidget_hh


#include <string>
#include <vector>
#include <map>


class TKinokoControlWidget {
  public:
    TKinokoControlWidget(const std::string& Name);
    virtual ~TKinokoControlWidget();
    virtual std::string Name(void);
    virtual std::string ActionOnClick(void);
    virtual void Enable(void) = 0;
    virtual void Disable(void) = 0;
    virtual std::string Value(void) = 0;
    virtual void SetValue(const std::string& Value) = 0;
  protected:
    std::string _Name;
    std::string _ActionOnClick;
};


class TKinokoButtonWidget: public TKinokoControlWidget {
  public:
    TKinokoButtonWidget(const std::string& Name, const std::string& ActionOnClick = "");
    virtual ~TKinokoButtonWidget();
    virtual std::string Value(void);
    virtual void SetValue(const std::string& Value);
};


class TKinokoLabelWidget: public TKinokoControlWidget {
  public:
    TKinokoLabelWidget(const std::string& Name);
    virtual ~TKinokoLabelWidget();
};


class TKinokoEntryWidget: public TKinokoControlWidget {
  public:
    TKinokoEntryWidget(const std::string& Name);
    virtual ~TKinokoEntryWidget();
};


class TKinokoTextBoxWidget: public TKinokoControlWidget {
  public:
    TKinokoTextBoxWidget(const std::string& Name);
    virtual ~TKinokoTextBoxWidget();
};


class TKinokoCheckButtonWidget: public TKinokoControlWidget {
  public:
    TKinokoCheckButtonWidget(const std::string& Name);
    virtual ~TKinokoCheckButtonWidget();
};


class TKinokoRadioButtonWidget: public TKinokoControlWidget {
  public:
    TKinokoRadioButtonWidget(const std::string& Name);
    virtual ~TKinokoRadioButtonWidget();
};


class TKinokoRadioButtonSetWidget: public TKinokoControlWidget {
  public:
    TKinokoRadioButtonSetWidget(const std::string& Name);
    virtual ~TKinokoRadioButtonSetWidget();
    virtual void AddRadioButton(TKinokoRadioButtonWidget* RadioButtonWidget);
    virtual std::string Value(void);
    virtual void SetValue(const std::string& Value);
    virtual void Enable(void);
    virtual void Disable(void);
  protected:
    std::vector<TKinokoRadioButtonWidget*> _RadioButtonList;
    std::map<std::string, TKinokoRadioButtonWidget*> _RadioButtonTable;
};


class TKinokoMenuItemWidget: public TKinokoControlWidget {
  public:
    TKinokoMenuItemWidget(const std::string& Name, const std::string& ActionOnClick = "");
    virtual ~TKinokoMenuItemWidget();
    virtual std::string Value(void);
    virtual void SetValue(const std::string& Value);
};


#endif
