/* KinokoShell.cc */
/* Created by Enomoto Sanshiro on 27 March 2002. */
/* Last updated by Enomoto Sanshiro on 27 March 2002. */


#include <iostream>
#include <strstream>
#include "KinokoShellConnector.hh"
#include "KinokoShellPopupWindow.hh"
#include "KinokoShell.hh"

using namespace std;


//#define DEBUG


TKinokoShell::TKinokoShell(TKinokoShellConnector* ShellConnector)
{
    _ShellConnector = ShellConnector;
    _IsRunning = false;
}

TKinokoShell::~TKinokoShell()
{
    map<string, TKinokoShellObject*>::iterator ObjectIterator;
    for (
	ObjectIterator = _ObjectTable.begin();	
	ObjectIterator != _ObjectTable.end();	
	ObjectIterator++
    ){
	delete (*ObjectIterator).second;
    }

    for (
	ObjectIterator = _PrototypeTable.begin();	
	ObjectIterator != _PrototypeTable.end();	
	ObjectIterator++
    ){
	delete (*ObjectIterator).second;
    }
}

void TKinokoShell::RegisterObjectPrototype(const std::string& ClassName, TKinokoShellObject* ObjectPrototype)
{
    _PrototypeTable[ClassName] = ObjectPrototype;
}

int TKinokoShell::ProcessInput(void)
{
    int ReceivedLength = _ShellConnector->ProcessInput();
    if (ReceivedLength <= 0) {
	return ReceivedLength;
    }

    const char* Line;
    while ((Line = _ShellConnector->NextLine()) != 0) {

	int Result = 0;
	istrstream InputStream(Line);

	if (Line[0] == '.') {
	    string Command;
	    InputStream >> Command;
	    Result = ProcessSystemCommand(Command, InputStream);
	}
	else {
	    Result = ProcessCommand(InputStream);
	}

#ifdef DEBUG
	if (! Result) {
	    cerr << "invalid command: " << Line << ";" << endl;
	}
	else {
	    cerr << "command: " << Line << ";" << endl;
	}
#endif
    }

    return ReceivedLength;
}

int TKinokoShell::ProcessSystemCommand(const string& Command, istream& InputStream)
{
    int Result = 1;

    if (Command == ".start") {
	_IsRunning = true;
    }
    else if (Command == ".stop") {
	_IsRunning = false;
    }
    else if (Command == ".quit") {
	TryToQuit();
    }
    else if (Command == ".create") {
	Result = ProcessCreateCommand(InputStream);
    }
    else {
	Result = 0;
    }

    return Result;
}

int TKinokoShell::ProcessCommand(std::istream& InputStream)
{
    int Result = 0;

    string ObjectName, Command;
    if ((InputStream >> ObjectName) && (_ObjectTable.count(ObjectName) > 0)){
	if (InputStream >> Command) {
	    Result = _ObjectTable[ObjectName]->ProcessCommand(
		Command, InputStream
	    );
	}
    }

    return Result;
}

int TKinokoShell::ProcessCreateCommand(istream& InputStream)
{
    int Result = 0;

    string ClassName, ObjectName;
    if (InputStream >> ClassName >> ObjectName) {
	if (_PrototypeTable.count(ClassName) > 0) {
	    TKinokoShellObject* Object = _PrototypeTable[ClassName]->Clone();
	    Result = Object->Construct(InputStream);

	    if (Result) {
		Object->SetName(ObjectName);
		_ObjectTable[ObjectName] = Object;
	    }
	    else {
		delete Object;
	    }
	}
    }

    return Result;
}

bool TKinokoShell::IsRunnung(void)
{
    return _IsRunning;
}

bool TKinokoShell::TryToQuit(void)
{
    bool IsReady = ! _IsRunning;

    if (! IsReady) {
	TKinokoShellPopupWindow* PopupWindow = CreatePopupWindow();

	PopupWindow->SetType("Warning");
	PopupWindow->SetMessage(
	    "System is running. -- Are you sure to quit?\n"
	    "(closing this window may crash the system)"
	);
	PopupWindow->AddAction("Yes");
	PopupWindow->AddAction("No");
	
	IsReady = (PopupWindow->Open(true) == "Yes");

	delete PopupWindow;
    }

    if (IsReady) {
	Quit();
    }

    return IsReady;
}



TKinokoShellObject::TKinokoShellObject(void)
{
}

TKinokoShellObject::~TKinokoShellObject()
{
}

int TKinokoShellObject::Construct(istream& InputStream)
{
    return 1;
}

void TKinokoShellObject::SetName(const string& ObjectName)
{
    _ObjectName = ObjectName;
}

const string& TKinokoShellObject::Name(void)
{
    return _ObjectName;
}
