/* KinokoShellConnector.hh */
/* Created by Enomoto Sanshiro on 3 October 2001. */
/* Last updated by Enomoto Sanshiro on 8 October 2001. */


#ifndef __KinokoShellConnector_hh
#define __KinokoShellConnector_hh


#include <iostream>
#include <string>
#include "MushNetworkSocket.hh"


class TKinokoShellConnector {
  public:
    TKinokoShellConnector(void);
    virtual ~TKinokoShellConnector();
    virtual int Connect(void) = 0;
    virtual int FileDescriptor(void);
    virtual int ProcessInput(void);
    virtual char* NextLine(void);
    virtual int SendMessage(void* Message, int Size) = 0;
  protected:
    virtual int ReceiveInput(void* Buffer, int MaxSize) = 0;
  protected:
    int _FileDescriptor;
    char* _Buffer;
    int _BufferSize;
    char* _DataStart;
    int _DataLength;
};


class TKinokoSocketShellConnector: public TKinokoShellConnector {
  public:
    TKinokoSocketShellConnector(const std::string& HostName, int PortNumber);
    virtual ~TKinokoSocketShellConnector();
    virtual int Connect(void);
    virtual int SendMessage(void* Message, int Size);
  protected:
    virtual int ReceiveInput(void* Buffer, int MaxSize);
  protected:
    std::string _HostName;
    int _PortNumber;
    TMushNetworkSocket* _Socket;
};


class TKinokoClientSocketShellConnector: public TKinokoSocketShellConnector {
  public:
    TKinokoClientSocketShellConnector(const std::string& HostName, int PortNumber);
    virtual ~TKinokoClientSocketShellConnector();
    virtual int Connect(void);
};


class TKinokoConsoleShellConnector: public TKinokoShellConnector {
  public:
    TKinokoConsoleShellConnector(void);
    virtual ~TKinokoConsoleShellConnector();
    virtual int Connect(void);
    virtual int SendMessage(void* Message, int Size);
  protected:
    virtual int ReceiveInput(void* Buffer, int MaxSize);
};


#endif
