/* KinokoShellScript.cc */
/* Created by Enomoto Sanshiro on 19 December 2002. */
/* Last updated by Enomoto Sanshiro on 19 December 2002. */


#include "ParaParser.hh"
#include "KinokoShellPopupWindow.hh"
#include "KinokoShellFileSelectDialog.hh"
#include "KinokoShellScript.hh"

using namespace std;


TKinokoShellScript::TKinokoShellScript(TKinokoShellPopupWindow* PopupWindow, TKinokoShellFileSelectDialog* FileSelectDialog)
{
    _PopupWindow = PopupWindow;
    _FileSelectDialog = FileSelectDialog;
}

TKinokoShellScript::~TKinokoShellScript()
{
}

TParaTokenTable* TKinokoShellScript::CreateTokenTable(void)
{
    TParaTokenTable* TokenTable = TParaStandardParser::CreateTokenTable();
    return TokenTable;
}

TParaOperatorTable* TKinokoShellScript::CreateOperatorTable(void)
{
    return TParaStandardParser::CreateOperatorTable();
}

TParaStatementTable* TKinokoShellScript::CreateStatementTable(void)
{
    TParaStatementTable* StatementTable;
    StatementTable = TParaStandardParser::CreateStatementTable();

    return StatementTable;
}

TParaPackage* TKinokoShellScript::CreatePackage(void)
{
    TParaPackage* Package = TParaStandardParser::CreatePackage();

    return Package;
}

TParaObjectPrototypeTable* TKinokoShellScript::CreateObjectPrototypeTable(void)
{
    TParaObjectPrototypeTable* ObjectPrototypeTable;
    ObjectPrototypeTable = TParaStandardParser::CreateObjectPrototypeTable();

    return ObjectPrototypeTable;
}

TParaBuiltinFunctionTable* TKinokoShellScript::CreateBuiltinFunctionTable(void)
{
    TParaBuiltinFunctionTable* BuiltinFunctionTable;
    BuiltinFunctionTable = TParaStandardParser::CreateBuiltinFunctionTable();

    BuiltinFunctionTable->RegisterAnonymousClass(
	new TKinokoShellPopupWindowMessenger(_PopupWindow)
    );
    BuiltinFunctionTable->RegisterAnonymousClass(
	new TKinokoShellFileSelectDialogMessenger(_FileSelectDialog)
    );

    return BuiltinFunctionTable;
}



TKinokoShellPopupWindowMessenger::TKinokoShellPopupWindowMessenger(TKinokoShellPopupWindow* PopupWindow)
: TParaObjectPrototype("PopupWindow")
{
    _PopupWindow = PopupWindow;
}

TKinokoShellPopupWindowMessenger::~TKinokoShellPopupWindowMessenger()
{
}

TParaObjectPrototype* TKinokoShellPopupWindowMessenger::Clone(void)
{
    return new TKinokoShellPopupWindowMessenger(_PopupWindow);
}

int TKinokoShellPopupWindowMessenger::MethodIdOf(const string& MethodName)
{
    if (MethodName == "openPopup") {
        return MethodId_OpenPopup;
    }
    if (MethodName == "openQueryPopup") {
        return MethodId_OpenQueryPopup;
    }

    return TParaObjectPrototype::MethodIdOf(MethodName);
}

int TKinokoShellPopupWindowMessenger::InvokeMethod(int MethodId, vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException)
{
    int Result = 0;

    switch (MethodId) {
      case MethodId_OpenPopup:
        Result = OpenPopup(ArgumentList, ReturnValue, false);
	break;
      case MethodId_OpenQueryPopup:
        Result = OpenPopup(ArgumentList, ReturnValue, true);
	break;
      default:
	Result = 0;
    }
    
    return Result;
}

int TKinokoShellPopupWindowMessenger::OpenPopup(vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue, bool IsModal) throw(TScriptException)
{
    if (ArgumentList.size() < 3) {
	throw TScriptException(
	    "openPopup(string type, string action_list, string message)",
	    "too few argument[s]"
	);
    }

    string Type = ArgumentList[0]->AsString();
    string ActionList = ArgumentList[1]->AsString();
    string Message = ArgumentList[2]->AsString();

    _PopupWindow->SetType(Type);
    _PopupWindow->SetMessage(Message);

    _PopupWindow->ClearActionList();
    istrstream ActionListStream(ActionList.c_str());
    string Action;
    while (ActionListStream >> Action) {
	_PopupWindow->AddAction(Action);
    }

    ReturnValue = TParaValue(_PopupWindow->Open(IsModal));

    return 1;
}



TKinokoShellFileSelectDialogMessenger::TKinokoShellFileSelectDialogMessenger(TKinokoShellFileSelectDialog* FileSelectDialog)
: TParaObjectPrototype("FileSelectDialog")
{
    _FileSelectDialog = FileSelectDialog;
}

TKinokoShellFileSelectDialogMessenger::~TKinokoShellFileSelectDialogMessenger()
{
}

TParaObjectPrototype* TKinokoShellFileSelectDialogMessenger::Clone(void)
{
    return new TKinokoShellFileSelectDialogMessenger(_FileSelectDialog);
}

int TKinokoShellFileSelectDialogMessenger::MethodIdOf(const string& MethodName)
{
    if (MethodName == "openFileSelectDialog") {
        return MethodId_OpenFileSelectDialog;
    }

    return TParaObjectPrototype::MethodIdOf(MethodName);
}

int TKinokoShellFileSelectDialogMessenger::InvokeMethod(int MethodId, vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException)
{
    int Result = 0;

    switch (MethodId) {
      case MethodId_OpenFileSelectDialog:
        Result = OpenFileSelectDialog(ArgumentList, ReturnValue);
	break;
      default:
	Result = 0;
    }
    
    return Result;
}

int TKinokoShellFileSelectDialogMessenger::OpenFileSelectDialog(vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException)
{
    string InitialFileName;
    if (ArgumentList.size() > 0) {
	InitialFileName = ArgumentList[0]->AsString();
    }

    ReturnValue = TParaValue(_FileSelectDialog->Open(InitialFileName));

    return 1;
}
