/* KinokoBoardGtk.hh */
/* Created by Enomoto Sanshiro on 29 October 2001. */
/* Last updated by Enomoto Sanshiro on 29 October 2001. */


#ifndef __KinokoBoardGtk_hh
#define __KinokoBoardGtk_hh


#include <gtk/gtk.h>
#include "KinokoShellConnector.hh"
#include "KinokoBoard.hh"


class TKinokoBoardGtk: public TKinokoBoard {
  public:
    TKinokoBoardGtk(TKinokoShellConnector* ShellConnector, int argc, char** argv, int Width = 400, int Height = 300);
    virtual ~TKinokoBoardGtk();
    virtual void Start(void);
    virtual void Quit(void);
    virtual void SetTitle(const std::string& Title);
  protected:
    virtual TKinokoShellPopupWindow* CreatePopupWindow(void);
    virtual TKinokoShellFileSelectDialog* CreateFileSelectDialog(void);
  public:
    virtual void WriteStatusMessage(const std::string& Message);
    virtual bool& IsDisplayFrozen(void);
  protected:
    virtual void Construct(void);
  protected:
    GtkWidget* _RootWindow;
    GtkWidget* _TextWidget;
    GtkWidget* _StatusBarEntryWidget;
    int _Width, _Height;
    bool _IsDisplayFrozen;
};


#endif
