/* KinokoCanvasTextAreaGtk.cc */
/* Created by Enomoto Sanshiro on 9 July 2000. */
/* Last updated by Enomoto Sanshiro on 9 July 2000. */


#include <gtk/gtk.h>
#include <gdk_imlib.h>
#include "KinokoCanvasTextAreaGtk.hh"

using namespace std;


TKinokoCanvasTextAreaGtk::TKinokoCanvasTextAreaGtk(GtkWidget* Text)
{
    _Text = Text;

    _CurrentColorIndex = AllocateColor(0, 0, 0);
    SetTextColor(_CurrentColorIndex);

    GtkStyle* Style = gtk_widget_get_style(Text);
    _CurrentFont = Style->font;
    _CurrentFontIndex = _FontList.size();
    _FontList.push_back(_CurrentFont);
}

TKinokoCanvasTextAreaGtk::~TKinokoCanvasTextAreaGtk()
{
}

void TKinokoCanvasTextAreaGtk::Clear(void)
{
}

void TKinokoCanvasTextAreaGtk::PutLine(const string& Line)
{
    gtk_text_insert(
	GTK_TEXT(_Text), _CurrentFont, _TextColor, NULL, 
	Line.c_str(), Line.size()
    );
}

int TKinokoCanvasTextAreaGtk::AllocateColor(float Red, float Green, float Blue)
{
    GdkColor* Color = new GdkColor();
    Color->red = (int) (Red * 0xffff);
    Color->green = (int) (Green * 0xffff);
    Color->blue = (int) (Blue * 0xffff);

    gdk_color_alloc(gdk_colormap_get_system(), Color);

    int ColorIndex = _ColorList.size();
    _ColorList.push_back(Color);

    return ColorIndex;
}

int TKinokoCanvasTextAreaGtk::SetTextColor(int ColorIndex)
{
    int OldColorIndex = _CurrentColorIndex;
    if (ColorIndex < (int) _ColorList.size()) {
	_TextColor = _ColorList[ColorIndex];
	_CurrentColorIndex = ColorIndex;
    }
    
    return OldColorIndex;
}

int TKinokoCanvasTextAreaGtk::LoadFont(const std::string& FontNameString)
{
    GdkFont* Font = gdk_font_load(FontNameString.c_str());
    if (Font == NULL) {
	return -1;
    }

    int FontIndex = _FontList.size();
    _FontList.push_back(Font);

    return FontIndex;
}

int TKinokoCanvasTextAreaGtk::SetFont(int FontIndex)
{
    if ((FontIndex < 0) || (FontIndex >= (int) _FontList.size())) {
	return _CurrentFontIndex;
    }

    int OldFontIndex = _CurrentFontIndex;
    _CurrentFont = _FontList[FontIndex];
    _CurrentFontIndex = FontIndex;

    return OldFontIndex;
}
