/* KinokoControlGtk.hh */
/* Created by Enomoto Sanshiro on 1 October 2001. */
/* Last updated by Enomoto Sanshiro on 1 October 2001. */


#ifndef __KinokoControlGtk_hh
#define __KinokoControlGtk_hh


#include "KinokoShellConnector.hh"
#include "KinokoShellPopupWindow.hh"
#include "KinokoControl.hh"
#include "KinokoControlWidget.hh"
#include "KinokoControlPanel.hh"
#include "KinokoControlPanelScript.hh"


class TKinokoControlGtk: public TKinokoControl {
  public:
    TKinokoControlGtk(TKinokoShellConnector* ShellConnector, int argc, char** argv);
    virtual ~TKinokoControlGtk();
    virtual void Start(void);
    virtual void Quit(void);
  protected:
    virtual TKinokoShellPopupWindow* CreatePopupWindow(void);
    virtual TKinokoShellFileSelectDialog* CreateFileSelectDialog(void);
  protected:
    virtual void Construct(const std::string& ScriptFileName);
  protected:
    TKinokoControlPanel* _ControlPanel;
    TKinokoControlPanelScript* _ControlPanelScript;
};


#endif
