/* KinokoControlPanelGtk.cc */
/* Created by Enomoto Sanshiro on 28 September 2001. */
/* Last updated by Enomoto Sanshiro on 28 September 2001. */


#include <cstring>
#include <iostream>
#include <iomanip>
#include <strstream>
#include <string>
#include <vector>
#include <deque>
#include <gtk/gtk.h>
#include "MushFileSystem.hh"
#include "KinokoShellAboutDialogGtk.hh"
#include "KinokoShellFileSelectDialogGtk.hh"
#include "KinokoControlGtk.hh"
#include "KinokoControlWidgetGtk.hh"
#include "KinokoControlPanelGtk.hh"

using namespace std;



static TKinokoControl* g_Control;

static gint delete_event_cb(GtkWidget* Widget, GdkEventAny* Event, gpointer Data);
static void menu_save_as_cb(void);
static void menu_load_cb(void);
static void menu_quit_cb(void);
static void menu_about_cb(void);
static void widget_clicked_cb(GtkWidget* Widget, gpointer Data);
static void file_select_cb(GtkWidget* Widget, gpointer Data);
static void increment_cb(GtkWidget* Widget, gpointer Data);


static GtkItemFactoryEntry MenuItemList[] = {
    {"/_File", (char*) NULL, 0, 0, "<Branch>"},
    {"/File/_Save Values As...", (char*) NULL, (GtkItemFactoryCallback) menu_save_as_cb, 0},
    {"/File/_Load Values...", (char*) NULL, (GtkItemFactoryCallback) menu_load_cb, 0},
    {"/File/", (char*) NULL, 0, 0, "<Separator>"},
    {"/File/e_Xit", "<control>X", (GtkItemFactoryCallback) menu_quit_cb, 0},
    {"/_Help", (char*) NULL, 0, 0, "<Branch>"},
    {"/Help/_About...", (char*) NULL, (GtkItemFactoryCallback) menu_about_cb, 0},
    {"/Help/", (char*) NULL, 0, 0, "<Separator>"},
};
static gint NumberOfMenuItems = sizeof(MenuItemList) / sizeof(MenuItemList[0]);



TKinokoControlPanelGtk::TKinokoControlPanelGtk(TKinokoControl* Control, const std::string& RootPath)
: TKinokoControlPanel(Control, RootPath)
{
    _RootWindow = 0;
    _CurrentFrame = 0;
    _CurrentHBox = 0;
    _CurrentVBox = 0;

    _IsInEntryList = false;
    _IsInButtonList = false;
    _IsInToolBar = false;
    _MenuCount = 1;  // the first one is the "File" menu

    _CurrentMenu = 0;
    _CheckButtonBox = 0;
    _RadioButtonBox = 0;

    g_Control = Control;

    BuildFontNameTable();
}

TKinokoControlPanelGtk::~TKinokoControlPanelGtk()
{
}

void TKinokoControlPanelGtk::CreateRootWindow(void)
{
    _RootWindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title(GTK_WINDOW(_RootWindow), "KinokoControlPanel");
    gtk_widget_realize(_RootWindow);

    GtkWidget* RootVBox = gtk_vbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(_RootWindow), RootVBox);

    // Menu and Menubar //
    GtkAccelGroup* AccelGroup = gtk_accel_group_new();
    _ItemFactory = gtk_item_factory_new(
	GTK_TYPE_MENU_BAR, "<menu>", AccelGroup
    );
    gtk_item_factory_create_items(
	_ItemFactory, NumberOfMenuItems, MenuItemList, NULL
    );
    gtk_accel_group_attach(AccelGroup, GTK_OBJECT(_RootWindow));
    GtkWidget* MenuBar = gtk_item_factory_get_widget(_ItemFactory, "<menu>");
    GtkWidget* MenuHandleBox = gtk_handle_box_new();
    gtk_container_add(GTK_CONTAINER(MenuHandleBox), MenuBar);
    gtk_box_pack_start(GTK_BOX(RootVBox), MenuHandleBox, FALSE, FALSE, 0);

    // ToolBar Box //
    _ToolBar = 0;
    _ToolBarHBox = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(RootVBox), _ToolBarHBox, FALSE, FALSE, 0);

    // Contents Box //
    GtkWidget* RootHBox = gtk_hbox_new(FALSE, 0);
    _CurrentVBox = gtk_vbox_new(FALSE, 0);
    _CurrentHBox = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(RootVBox), RootHBox, FALSE, FALSE, 3);
    gtk_box_pack_start(GTK_BOX(RootHBox), _CurrentVBox, FALSE, FALSE, 3);
    gtk_box_pack_start(GTK_BOX(_CurrentVBox), _CurrentHBox, FALSE, FALSE, 0);

    gtk_signal_connect(
	GTK_OBJECT(_RootWindow), "delete_event", 
	GTK_SIGNAL_FUNC(delete_event_cb), NULL
    );
}

void TKinokoControlPanelGtk::OpenPanel(map<string, string>& OptionTable)
{
    string Name = OptionTable["name"];
    string Label = OptionTable["label"];

    if (_RootWindow == 0) {
	CreateRootWindow();
	gtk_window_set_title(GTK_WINDOW(_RootWindow), Label.c_str());
    }
}

void TKinokoControlPanelGtk::ClosePanel(void)
{
    gtk_widget_show_all(_RootWindow);
}

void TKinokoControlPanelGtk::OpenFrame(map<string, string>& OptionTable)
{
    string Name = OptionTable["name"];
    string Label = OptionTable["label"];

    _FrameStack.push_front(_CurrentFrame);
    _VBoxStack.push_front(_CurrentVBox);
    _HBoxStack.push_front(_CurrentHBox);

    _CurrentFrame = gtk_frame_new(Label.c_str());
    gtk_box_pack_start(GTK_BOX(_CurrentHBox), _CurrentFrame, TRUE, TRUE, 0);

    _CurrentVBox = gtk_vbox_new(FALSE, 0);
    _CurrentHBox = gtk_hbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(_CurrentFrame), _CurrentVBox);
    gtk_box_pack_start(GTK_BOX(_CurrentVBox), _CurrentHBox, FALSE, FALSE, 3);

    gtk_container_border_width(GTK_CONTAINER(_CurrentFrame), 3);
}

void TKinokoControlPanelGtk::CloseFrame(void)
{
    _CurrentFrame = _FrameStack.front();
    _CurrentVBox = _VBoxStack.front();
    _CurrentHBox = _HBoxStack.front();

    _FrameStack.pop_front();
    _VBoxStack.pop_front();
    _HBoxStack.pop_front();
}

void TKinokoControlPanelGtk::OpenBox(map<string, string>& OptionTable)
{
    GtkWidget* OldHBox = _CurrentHBox;
    _VBoxStack.push_front(_CurrentVBox);
    _HBoxStack.push_front(_CurrentHBox);

    _CurrentVBox = gtk_vbox_new(FALSE, 0);
    _CurrentHBox = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(OldHBox), _CurrentVBox, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(_CurrentVBox), _CurrentHBox, FALSE, FALSE, 0);
}

void TKinokoControlPanelGtk::CloseBox(void)
{
    _CurrentVBox = _VBoxStack.front();
    _CurrentHBox = _HBoxStack.front();

    _VBoxStack.pop_front();
    _HBoxStack.pop_front();
}

void TKinokoControlPanelGtk::OpenToolBar(map<string, string>& OptionTable)
{
    if (_ToolBar == 0) {
	_ToolBar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
	GtkWidget* HandleBox = gtk_handle_box_new();
	gtk_container_add(GTK_CONTAINER(HandleBox), _ToolBar);
	gtk_box_pack_start(GTK_BOX(_ToolBarHBox), HandleBox, TRUE, TRUE, 0);
    }

    _IsInToolBar = true;
}

void TKinokoControlPanelGtk::CloseToolBar(void)
{
    _IsInToolBar = false;
}

void TKinokoControlPanelGtk::OpenEntryList(map<string, string>& OptionTable)
{
    _IsInEntryList = true;
}

void TKinokoControlPanelGtk::CloseEntryList(void)
{
    int NumberOfEntries = _EntryLabelList.size();

    GtkWidget* TableWidget = gtk_table_new(NumberOfEntries, 3, FALSE);
    for (int i = 0; i < NumberOfEntries; i++) {
	GtkWidget* LabelWidget = _EntryLabelList[i];
	GtkWidget* EntryWidget = _EntryEntryList[i];
	GtkWidget* OptionWidget = _EntryOptionList[i];
	
	gtk_table_attach(
	    GTK_TABLE(TableWidget), LabelWidget, 
	    0, 1, i, i + 1,
	    GTK_FILL, GTK_SHRINK, 3, 2
	);
	gtk_table_attach(
	    GTK_TABLE(TableWidget), EntryWidget, 
	    1, 2, i, i + 1,
	    GTK_FILL, GTK_SHRINK, 3, 2
	);
	if (OptionWidget != 0) {
	    gtk_table_attach(
		GTK_TABLE(TableWidget), OptionWidget, 
		2, 3, i, i + 1,
		GTK_FILL, GTK_SHRINK, 0, 2
	    );
	}
    }

    gtk_box_pack_start(GTK_BOX(_CurrentHBox), TableWidget, FALSE, FALSE, 10);

    _EntryLabelList.erase(_EntryLabelList.begin(), _EntryLabelList.end());
    _EntryEntryList.erase(_EntryEntryList.begin(), _EntryEntryList.end());
    _EntryOptionList.erase(_EntryOptionList.begin(), _EntryOptionList.end());
    _IsInEntryList = false;
}

void TKinokoControlPanelGtk::AddEntry(map<string, string>& OptionTable)
{
    string Name = OptionTable["name"];
    string Label = OptionTable["label"];
    string Selection = OptionTable["selection"];
    string Width = OptionTable["width"];
    string Alignment = OptionTable["alignment"];
    string Option = OptionTable["option"]; //...

    GtkWidget* LabelWidget = gtk_label_new(Label.c_str());
    GtkWidget* InputWidget;
    GtkWidget* EntryWidget;
    GtkWidget* OptionWidget = 0;

    if (Selection.empty()) {
	EntryWidget = gtk_entry_new();
	InputWidget = EntryWidget;
    }
    else {
	GList* ItemList = NULL;   //... have to be released
	string Item;
	istrstream SelectionStream(Selection.c_str());
	while (SelectionStream >> Item) {
	    ItemList = g_list_append(ItemList, strdup(Item.c_str()));
	}

	InputWidget = gtk_combo_new();
	EntryWidget = GTK_COMBO(InputWidget)->entry;

	gtk_combo_set_popdown_strings(GTK_COMBO(InputWidget), ItemList);
	gtk_entry_set_editable(GTK_ENTRY(EntryWidget), FALSE);
    }

    if (! Width.empty()) {
	int WidthValue;
	if (istrstream(Width.c_str()) >> WidthValue) {
	    gtk_widget_set_usize(
		InputWidget, WidthValue, InputWidget->requisition.height
	    );
	}
    }

    if (! Alignment.empty()) {
	if (Alignment == "right") {
	    ;
	}
    }

    if (Option == "file_select") {
	OptionWidget = gtk_button_new_with_label("select...");
	gtk_signal_connect(
	    GTK_OBJECT(OptionWidget), "clicked", 
	    GTK_SIGNAL_FUNC(file_select_cb), EntryWidget
	);
    }
    else if (Option == "increment") {
	OptionWidget = gtk_button_new_with_label("+1");
	gtk_signal_connect(
	    GTK_OBJECT(OptionWidget), "clicked", 
	    GTK_SIGNAL_FUNC(increment_cb), EntryWidget
	);
    }

    if (_IsInEntryList) {
	_EntryLabelList.push_back(LabelWidget);
	_EntryEntryList.push_back(InputWidget);
	_EntryOptionList.push_back(OptionWidget);
    }
    else {
	gtk_box_pack_start(
	    GTK_BOX(_CurrentHBox), LabelWidget, FALSE, FALSE, 3
	);
	gtk_box_pack_start(
	    GTK_BOX(_CurrentHBox), InputWidget, FALSE, FALSE, 3
	);
	if (OptionWidget != 0) {
	    gtk_box_pack_start(
		GTK_BOX(_CurrentHBox), OptionWidget, FALSE, FALSE, 3
	    );
	}
    }
    
    TKinokoControlWidget* ControlWidget;
    ControlWidget = new TKinokoEntryWidgetGtk(Name, EntryWidget);

    _Control->AddWidget(ControlWidget);
    _Control->AddInputWidget(ControlWidget);
}

void TKinokoControlPanelGtk::OpenButtonList(map<string, string>& OptionTable)
{
    _CurrentHBox = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(_CurrentVBox), _CurrentHBox, FALSE, FALSE, 3);

    GtkWidget* HPaddingWidget = gtk_label_new("");
    gtk_box_pack_start(GTK_BOX(_CurrentHBox), HPaddingWidget, TRUE, TRUE, 3);

    GtkWidget* ButtonBox = gtk_hbox_new(TRUE, 0);
    gtk_box_pack_start(GTK_BOX(_CurrentHBox), ButtonBox, FALSE, FALSE, 3);
    _CurrentHBox = ButtonBox;
    _IsInButtonList = true;
}

void TKinokoControlPanelGtk::CloseButtonList(void)
{
    _IsInButtonList = false;
}

void TKinokoControlPanelGtk::AddButton(map<string, string>& OptionTable)
{
    string Name = OptionTable["name"];
    string Label = OptionTable["label"];
    string ImageFileName = OptionTable["image"];
    string Tip = OptionTable["tip"];
    string EnabledStateList = OptionTable["enabled_on"];
    string ActionOnClick = OptionTable["on_click"];

    GtkWidget* ButtonWidget = 0;
    if (! ImageFileName.empty()) {
	if (! TMushFileAttribute(ImageFileName).IsReadable()) {
	    string FilePath = TMushFileAttribute(ImageFileName).PathName();
	    if (FilePath.empty() && (! _RootPath.empty())) {
		ImageFileName = _RootPath + ImageFileName;
	    }
	}
	
	GdkBitmap* Mask;
	GdkPixmap* PixmapData;
	PixmapData = gdk_pixmap_create_from_xpm(
	    _RootWindow->window, &Mask, 0, ImageFileName.c_str()
	);

	if (PixmapData != NULL) {
	    ButtonWidget = gtk_button_new();
	    GtkWidget* Pixmap = gtk_pixmap_new(PixmapData, Mask);
	    gtk_widget_show(Pixmap);
	    gtk_container_add(GTK_CONTAINER(ButtonWidget), Pixmap);
	}
    }
    if ((ButtonWidget == 0) && (! Label.empty())) {
	ButtonWidget = gtk_button_new_with_label(Label.c_str());
    }
    if ((ButtonWidget == 0) && (! Name.empty())) {
	ButtonWidget = gtk_button_new_with_label(Name.c_str());
    }
    if (ButtonWidget == 0) {
	ButtonWidget = gtk_button_new_with_label("\?\?\?");
    }

    if (! Tip.empty()) {
	GtkTooltips* ToolTips = gtk_tooltips_new();
	gtk_tooltips_set_tip(ToolTips, ButtonWidget, Tip.c_str(), NULL);
    }

    if (_IsInButtonList) {
	gtk_box_pack_start(
	    GTK_BOX(_CurrentHBox), ButtonWidget, TRUE, TRUE, 2
	);
    }
    else if (_IsInToolBar) {
	gtk_toolbar_append_widget(
	    GTK_TOOLBAR(_ToolBar), ButtonWidget, Tip.c_str(), ""
	);
    }
    else {
	gtk_box_pack_start(
	    GTK_BOX(_CurrentHBox), ButtonWidget, FALSE, FALSE, 3
	);
    }

    TKinokoControlWidget* ControlWidget;
    ControlWidget = new TKinokoButtonWidgetGtk(
	Name, ButtonWidget, ActionOnClick
    );

    gtk_signal_connect(
	GTK_OBJECT(ButtonWidget), "clicked", 
	GTK_SIGNAL_FUNC(widget_clicked_cb), ControlWidget
    );

    _Control->AddWidget(ControlWidget, EnabledStateList);
}

void TKinokoControlPanelGtk::OpenCheckButtonList(map<string, string>& OptionTable)
{
    _CheckButtonBox = gtk_vbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(_CurrentHBox), _CheckButtonBox, FALSE, FALSE, 2);
}

void TKinokoControlPanelGtk::CloseCheckButtonList(void)
{
    _CheckButtonBox = 0;
}

void TKinokoControlPanelGtk::AddCheckButton(map<string, string>& OptionTable)
{
    string Name = OptionTable["name"];
    string Label = OptionTable["label"];

    GtkWidget* ButtonWidget = gtk_check_button_new_with_label(Label.c_str());

    if (_CheckButtonBox != 0) {
	gtk_box_pack_start(
	    GTK_BOX(_CheckButtonBox), ButtonWidget, FALSE, FALSE, 0
	);
    }
    else {
	gtk_box_pack_start(
	    GTK_BOX(_CurrentHBox), ButtonWidget, FALSE, FALSE, 0
	);
    }

    TKinokoControlWidget* ControlWidget;
    ControlWidget = new TKinokoCheckButtonWidgetGtk(Name, ButtonWidget);

    _Control->AddWidget(ControlWidget);
    _Control->AddInputWidget(ControlWidget);
}

void TKinokoControlPanelGtk::OpenRadioButtonList(map<string, string>& OptionTable)
{
    string Name = OptionTable["name"];

    _RadioButtonBox = gtk_vbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(_CurrentHBox), _RadioButtonBox, FALSE, FALSE, 2);
    _RadioButtonGroup = NULL;
    _RadioButtonSet = new TKinokoRadioButtonSetWidget(Name);
}

void TKinokoControlPanelGtk::CloseRadioButtonList(void)
{
    _Control->AddWidget(_RadioButtonSet);
    _Control->AddInputWidget(_RadioButtonSet);

    _RadioButtonBox = 0;
    _RadioButtonSet = 0;
}

void TKinokoControlPanelGtk::AddRadioButton(map<string, string>& OptionTable)
{
    string Name = OptionTable["name"];
    string Label = OptionTable["label"];

    if (_RadioButtonBox == 0) {
	AddCheckButton(OptionTable);
	return;
    }

    GtkWidget* ButtonWidget = gtk_radio_button_new_with_label(
	_RadioButtonGroup, Label.c_str()
    );
    _RadioButtonGroup = gtk_radio_button_group(GTK_RADIO_BUTTON(ButtonWidget));

    gtk_box_pack_start(
	GTK_BOX(_RadioButtonBox), ButtonWidget, FALSE, FALSE, 0
    );

    _RadioButtonSet->AddRadioButton(
	new TKinokoRadioButtonWidgetGtk(Name, ButtonWidget)
    );
}

void TKinokoControlPanelGtk::OpenMenu(std::map<std::string, std::string>& OptionTable)
{
    string Name = OptionTable["name"];
    string Label = OptionTable["label"];

    string Path = "/"+ Label;
    GtkWidget* Menu = gtk_item_factory_get_widget(_ItemFactory, Path.c_str());

    if (Menu == 0) {
	Menu = gtk_menu_new();

	GtkWidget* MenuBar = gtk_item_factory_get_widget(_ItemFactory, "<menu>");
	GtkWidget* MenuItem = gtk_menu_item_new_with_label(Label.c_str());
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(MenuItem), Menu);
	gtk_menu_bar_insert(GTK_MENU_BAR(MenuBar), MenuItem, _MenuCount++);
	gtk_widget_show(MenuItem);
    }

    _CurrentMenu = Menu;
}

void TKinokoControlPanelGtk::CloseMenu(void)
{
    _CurrentMenu = 0;
}

void TKinokoControlPanelGtk::AddMenuItem(std::map<std::string, std::string>& OptionTable)
{
    string Name = OptionTable["name"];
    string Label = OptionTable["label"];
    string EnabledStateList = OptionTable["enabled_on"];
    string ActionOnClick = OptionTable["on_click"];

    if (_CurrentMenu == 0) {
	cerr << "KCML ERROR: menu item outside menu: " << Name << endl;
	return;
    }

    if (Label.empty()) {
	Label = Name;
    }

    GtkWidget* MenuItem = gtk_menu_item_new_with_label(Label.c_str());
    gtk_menu_append(GTK_MENU(_CurrentMenu), MenuItem);
    gtk_widget_show(MenuItem);

    TKinokoControlWidget* ControlWidget;
    ControlWidget = new TKinokoMenuItemWidgetGtk(
	Name, MenuItem, ActionOnClick
    );

    gtk_signal_connect(
	GTK_OBJECT(MenuItem), "activate", 
	GTK_SIGNAL_FUNC(widget_clicked_cb), ControlWidget
    );

    _Control->AddWidget(ControlWidget, EnabledStateList);
}

void TKinokoControlPanelGtk::AddLabel(map<string, string>& OptionTable)
{
    string Name = OptionTable["name"];
    string Label = OptionTable["label"];
    string FontName = OptionTable["font"];
    string FontSize = OptionTable["size"];

    GtkWidget* LabelWidget = gtk_label_new(Label.c_str());
    gtk_box_pack_start(GTK_BOX(_CurrentHBox), LabelWidget, FALSE, FALSE, 3);

    if (! FontName.empty() || ! FontSize.empty()) {
        GdkFont* Font = LoadFont(FontName, FontSize);
	if (Font != NULL) {
	    GtkStyle* Style = gtk_widget_get_style(LabelWidget);
	    GtkStyle* NewStyle = gtk_style_copy(Style);
	    NewStyle->font = Font;

	    gtk_widget_set_style(LabelWidget, NewStyle);
	}
    }

    _Control->AddWidget(new TKinokoLabelWidgetGtk(Name, LabelWidget));
}

void TKinokoControlPanelGtk::AddTextBox(std::map<std::string, std::string>& OptionTable)
{
    string Name = OptionTable["name"];
    //string Label = OptionTable["label"];

    //GtkWidget* LabelWidget = gtk_label_new(Label.c_str());
    GtkWidget* TextWidget = gtk_text_new(NULL, NULL);

    gtk_box_pack_start(GTK_BOX(_CurrentHBox), TextWidget, TRUE, TRUE, 10);

    TKinokoControlWidget* ControlWidget;
    ControlWidget = new TKinokoTextBoxWidgetGtk(Name, TextWidget);

    _Control->AddWidget(ControlWidget);
    _Control->AddInputWidget(ControlWidget);
}

void TKinokoControlPanelGtk::AddImage(map<string, string>& OptionTable)
{
    string ImageFileName = OptionTable["file"];

    if (! TMushFileAttribute(ImageFileName).IsReadable()) {
	string ImageFilePath = TMushFileAttribute(ImageFileName).PathName();
	if (ImageFilePath.empty() && (! _RootPath.empty())) {
	    ImageFileName = _RootPath + ImageFileName;
	}
    }

    GdkBitmap* Mask;
    GdkPixmap* PixmapData;
    PixmapData = gdk_pixmap_create_from_xpm(
	_RootWindow->window, &Mask, 0, ImageFileName.c_str()
    );

    GtkWidget* Widget;
    if (PixmapData != NULL) {
	Widget = gtk_pixmap_new(PixmapData, Mask);
    }
    else {
	Widget = gtk_label_new("image");
    }

    gtk_box_pack_start(GTK_BOX(_CurrentHBox), Widget, FALSE, FALSE, 3);
}

void TKinokoControlPanelGtk::VSpace(map<string, string>& OptionTable)
{
    if (_CurrentMenu) {
#if 0	
	//... old GTK library does not have this function ...//
	GtkWidget* MenuItem = gtk_separator_menu_item_new();
#else
	GtkWidget* MenuItem = gtk_menu_item_new();
#endif

	gtk_menu_append(GTK_MENU(_CurrentMenu), MenuItem);
	gtk_widget_show(MenuItem);
    }
    else {
	NewLine(OptionTable);
	HSpace(OptionTable);
	NewLine(OptionTable);
    }
}

void TKinokoControlPanelGtk::HSpace(map<string, string>& OptionTable)
{
    if (_IsInToolBar) {
	gtk_toolbar_append_space(GTK_TOOLBAR(_ToolBar));
    }
    else {
	GtkWidget* HPaddingWidget = gtk_label_new("");
	gtk_box_pack_start(GTK_BOX(_CurrentHBox), HPaddingWidget, TRUE, TRUE, 0);
    }
}

void TKinokoControlPanelGtk::NewLine(map<string, string>& OptionTable)
{
    _CurrentHBox = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(_CurrentVBox), _CurrentHBox, FALSE, FALSE, 0);
}

void TKinokoControlPanelGtk::BuildFontNameTable(void)
{
    //... this table should be shared with the class TKinokoCanvasImageAreaGtk.
    _PredefinedFontNameTable["times"] = "-*-times-medium-r-normal";
    _PredefinedFontNameTable["times-roman"] = "-*-times-medium-r-normal";
    _PredefinedFontNameTable["times-italic"] = "-*-times-medium-i-normal";
    _PredefinedFontNameTable["times-bold"] = "-*-times-bold-r-normal";
    _PredefinedFontNameTable["times-bolditalic"] = "-*-times-bold-i-normal";
    _PredefinedFontNameTable["helvetica"] = "-*-helvetica-medium-r-normal";
    _PredefinedFontNameTable["helvetica-oblique"] = "-*-helvetica-medium-o-normal";
    _PredefinedFontNameTable["helvetica-bold"] = "-*-helvetica-bold-r-normal";
    _PredefinedFontNameTable["helvetica-boldoblique"] = "-*-helvetica-bold-o-normal";
    _PredefinedFontNameTable["courier"] = "-*-courier-medium-r-normal";
    _PredefinedFontNameTable["courier-oblique"] = "-*-courier-medium-o-normal";
    _PredefinedFontNameTable["courier-bold"] = "-*-courier-bold-r-normal";
    _PredefinedFontNameTable["courier-boldoblique"] = "-*-courier-bold-o-normal";
    _PredefinedFontNameTable["symbol"] = "-*-symbol-medium-r-normal";
}

GdkFont* TKinokoControlPanelGtk::LoadFont(string FontName, string FontSize)
{
    //...
    if (FontName.empty()) {
        FontName = "helvetica";
    }
    if (FontSize.empty()) {
        FontSize = "12";
    }

    string SystemFontName;
    if (_PredefinedFontNameTable.count(FontName) > 0) {
	SystemFontName = (
            _PredefinedFontNameTable[FontName] + "-*-" + FontSize + "-*-*-*-*-*-*-*"
	);
    }
    else {
	size_t Separator;
	if ((Separator = FontName.find_first_of(":")) != string::npos) {
	    string TypeName = FontName.substr(0, Separator);
	    string Parameter = FontName.substr(Separator + 1, string::npos);

	    if (TypeName == "x") {
	        // X-Window font //
                SystemFontName = Parameter;
	    }
	}
    }

    if (SystemFontName.empty()) {
        return 0;
    }
    else {
        return gdk_font_load(SystemFontName.c_str());
    }
}



static void widget_clicked_cb(GtkWidget* Widget, gpointer Data)
{
    if (g_Control != 0) {
	g_Control->OnClickWidget((TKinokoControlWidget*) Data);
    }
}

static void menu_save_as_cb(void)
{
    if (g_Control == 0) {
	return;
    }

    string FileName = TKinokoShellFileSelectDialogGtk().Open();
    if (! FileName.empty()) {
	g_Control->SaveValuesTo(FileName);
    }
}

static void menu_load_cb(void)
{
    if (g_Control == 0) {
	return;
    }

    string FileName = TKinokoShellFileSelectDialogGtk().Open();
    if (! FileName.empty()) {
	g_Control->LoadValuesFrom(FileName);
    }
}

static void menu_quit_cb(void)
{
    g_Control->TryToQuit();
}

static void menu_about_cb(void)
{
    TKinokoShellAboutDialogGtk AboutDialog;

    AboutDialog.SetTitle("Kinoko Control ver. 1.0");
    AboutDialog.SetCopyright("Copyright 2001-2002, Enomoto Sanshiro");
    AboutDialog.AddAuthor("Enomoto Sanshiro <sanshiro@awa.tohoku.ac.jp>");
    //AboutDialog.AddComment("The application makes you happy.");

    AboutDialog.Open();
}

static gint delete_event_cb(GtkWidget* Widget, GdkEventAny* Event, gpointer Data)
{
    bool Result = g_Control->TryToQuit();
    return Result ? FALSE : TRUE;
}

static void file_select_cb(GtkWidget* Widget, gpointer Data)
{
    GtkWidget* EntryWidget = GTK_WIDGET(Data);
    string InitialFileName = gtk_entry_get_text(GTK_ENTRY(EntryWidget));

    string SelectedFile = TKinokoShellFileSelectDialogGtk().Open(InitialFileName);

    if (! SelectedFile.empty()) {
	gtk_entry_set_text(GTK_ENTRY(EntryWidget), SelectedFile.c_str());
    }
}

static void increment_cb(GtkWidget* Widget, gpointer Data)
{
    GtkWidget* EntryWidget = GTK_WIDGET(Data);
    string OriginalValue = gtk_entry_get_text(GTK_ENTRY(EntryWidget));

    long Value = 0;
    if (! (istrstream(OriginalValue.c_str()) >> Value)) {
	Value = 0;
    }
    ++Value;

    char NewValue[32];
    ostrstream NewValueStream(NewValue, sizeof(NewValue));
    NewValueStream << setw(OriginalValue.size()) << setfill('0') << Value << ends;

    gtk_entry_set_text(GTK_ENTRY(EntryWidget), NewValue);
}
