/* KinokoControlPanelScriptGtk.cc */
/* Created by Enomoto Sanshiro on 28 September 2001. */
/* Last updated by Enomoto Sanshiro on 31 October 2001. */


#include <fstream>
#include <string>
#include <cstring>
#include <cctype>
#include <map>
#include <parser.h>
#include <parserInternals.h>
#include "KinokoControlPanel.hh"
#include "KinokoControlPanelScript.hh"
#include "KinokoControlPanelScriptGtk.hh"

using namespace std;


static TKinokoControlPanelScript* g_Script = 0;

static xmlSAXHandler SaxHandlerList;
static void sax_start_element(void* ctxt, const CHAR* name, const CHAR** attrs);
static void sax_end_element(void* ctxt, const CHAR* name);
static void sax_characters(void* ctxt, const CHAR* ch, int len);
static void sax_comment(void* ctxt, const CHAR* ch);
static void sax_error(void* ctx, const char* msg, ...);



TKinokoControlPanelScriptXmlGtk::TKinokoControlPanelScriptXmlGtk(TKinokoControlPanel* ControlPanel, const string& ScriptFileName)
: TKinokoControlPanelScript(ControlPanel, ScriptFileName)
{
    _XmlParserContext = 0;

    memset(&SaxHandlerList, sizeof(SaxHandlerList), 0);
    SaxHandlerList.startElement = sax_start_element;
    SaxHandlerList.endElement = sax_end_element;
    SaxHandlerList.characters = sax_characters;
    SaxHandlerList.comment = sax_comment;
    SaxHandlerList.warning = sax_error;
    SaxHandlerList.error = sax_error;
    SaxHandlerList.fatalError = sax_error;
}

TKinokoControlPanelScriptXmlGtk::~TKinokoControlPanelScriptXmlGtk()
{
    if (_XmlParserContext != 0) {
	_XmlParserContext->sax = NULL;
	xmlFreeParserCtxt(_XmlParserContext);
    }
}

void TKinokoControlPanelScriptXmlGtk::Go(void)
{
    if (g_Script != 0) {
	return;
    }
    g_Script = this;

    _XmlParserContext = xmlCreateFileParserCtxt(_ScriptFileName.c_str());
    if (! _XmlParserContext) {
	OnScriptError("ERROR: unable to open file: " + _ScriptFileName);
	return;
    }
    _XmlParserContext->sax = &SaxHandlerList;

    xmlParseDocument(_XmlParserContext);
    if (! _XmlParserContext->wellFormed) {
	OnScriptError("ERROR: badly formed XML file: " + _ScriptFileName);
	return;
    }
}

static void sax_start_element(void* ctxt, const CHAR* name, const CHAR** attrs)
{
    string WidgetTypeName;
    for (int i = 0; name[i] != '\0'; i++) {
	WidgetTypeName += tolower(name[i]);
    }

    map<string, string> OptionTable;
    if (attrs) {
	const char* Attribute;
	string Name, Value;
	for (int i = 0; (Attribute = (const char*) attrs[i]) != NULL; i++) {
	    if (i % 2 == 0) {
		Name = Attribute;
	    }
	    else {
		Value = Attribute;
		OptionTable[Name] = Value;
	    }
	}
    }

    g_Script->OnStartWidget(WidgetTypeName, OptionTable);
}

static void sax_end_element(void* ctxt, const CHAR* name)
{
    string WidgetTypeName;
    for (int i = 0; name[i] != '\0'; i++) {
	WidgetTypeName += tolower(name[i]);
    }

    g_Script->OnEndWidget(WidgetTypeName);
}

static void sax_characters(void* ctxt, const CHAR* ch, int len)
{
    for (int i = 0; i < len; i++) {
	g_Script->OnCharacter(ch[i]);
    }
}

static void sax_comment(void* ctxt, const CHAR* ch)
{
    while (*ch != '\0') {
	g_Script->OnCommentCharacter(*(ch++));
    }
}

static void sax_error(void* ctx, const char* msg, ...)
{
    string Message = (const char*) msg;
    g_Script->OnScriptError(Message);
}
