/* KinokoControlWidgetGtk.cc */
/* Created by Enomoto Sanshiro on 30 September 2001. */
/* Last updated by Enomoto Sanshiro on 30 September 2001. */


#include <string>
#include <vector>
#include <gtk/gtk.h>
#include "KinokoControlWidget.hh"
#include "KinokoControlWidgetGtk.hh"

using namespace std;



TKinokoButtonWidgetGtk::TKinokoButtonWidgetGtk(const string& Name, GtkWidget* ButtonWidget, const std::string& ActionOnClick)
: TKinokoButtonWidget(Name, ActionOnClick)
{
    _ButtonWidget = ButtonWidget;
}

TKinokoButtonWidgetGtk::~TKinokoButtonWidgetGtk()
{
}

void TKinokoButtonWidgetGtk::Enable(void)
{
    gtk_widget_set_sensitive(GTK_WIDGET(_ButtonWidget), TRUE);
}

void TKinokoButtonWidgetGtk::Disable(void)
{
    gtk_widget_set_sensitive(GTK_WIDGET(_ButtonWidget), FALSE);
}



TKinokoLabelWidgetGtk::TKinokoLabelWidgetGtk(const string& Name, GtkWidget* LabelWidget)
: TKinokoLabelWidget(Name)
{
    _LabelWidget = LabelWidget;
}

TKinokoLabelWidgetGtk::~TKinokoLabelWidgetGtk()
{
}

string TKinokoLabelWidgetGtk::Value(void)
{
    return "label";
}

void TKinokoLabelWidgetGtk::SetValue(const string& Value)
{
    gtk_label_set_text(GTK_LABEL(_LabelWidget), Value.c_str());
}

void TKinokoLabelWidgetGtk::Enable(void)
{
}

void TKinokoLabelWidgetGtk::Disable(void)
{
}



TKinokoEntryWidgetGtk::TKinokoEntryWidgetGtk(const string& Name, GtkWidget* EntryWidget)
: TKinokoEntryWidget(Name)
{
    _EntryWidget = EntryWidget;
}

TKinokoEntryWidgetGtk::~TKinokoEntryWidgetGtk()
{
}

string TKinokoEntryWidgetGtk::Value(void)
{
    return gtk_entry_get_text(GTK_ENTRY(_EntryWidget));
}

void TKinokoEntryWidgetGtk::SetValue(const string& Value)
{
    gtk_entry_set_text(GTK_ENTRY(_EntryWidget), Value.c_str());
}

void TKinokoEntryWidgetGtk::Enable(void)
{
    gtk_entry_set_editable(GTK_ENTRY(_EntryWidget), TRUE);
}

void TKinokoEntryWidgetGtk::Disable(void)
{
    gtk_entry_set_editable(GTK_ENTRY(_EntryWidget), FALSE);
}



TKinokoTextBoxWidgetGtk::TKinokoTextBoxWidgetGtk(const string& Name, GtkWidget* TextWidget)
: TKinokoTextBoxWidget(Name)
{
    _TextWidget = TextWidget;
}

TKinokoTextBoxWidgetGtk::~TKinokoTextBoxWidgetGtk()
{
}

string TKinokoTextBoxWidgetGtk::Value(void)
{
    char* Buffer = gtk_editable_get_chars(GTK_EDITABLE(_TextWidget), 0, -1);
    string Value = Buffer;
    g_free(Buffer);

    return Value;
}

void TKinokoTextBoxWidgetGtk::SetValue(const string& Value)
{
    //...
}

void TKinokoTextBoxWidgetGtk::Enable(void)
{
    gtk_text_set_editable(GTK_TEXT(_TextWidget), TRUE);
}

void TKinokoTextBoxWidgetGtk::Disable(void)
{
    gtk_text_set_editable(GTK_TEXT(_TextWidget), FALSE);
}



TKinokoCheckButtonWidgetGtk::TKinokoCheckButtonWidgetGtk(const string& Name, GtkWidget* CheckButtonWidget)
: TKinokoCheckButtonWidget(Name)
{
    _CheckButtonWidget = CheckButtonWidget;
}

TKinokoCheckButtonWidgetGtk::~TKinokoCheckButtonWidgetGtk()
{
}

string TKinokoCheckButtonWidgetGtk::Value(void)
{
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(_CheckButtonWidget))) {
	return "1";
    }
    else {
	return "0";
    }
}

void TKinokoCheckButtonWidgetGtk::SetValue(const string& Value)
{
    gboolean State;
    if (Value.empty() || (Value == "0")) {
	State = FALSE;
    }
    else {
	State = TRUE;
    }

    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(_CheckButtonWidget), State);
}

void TKinokoCheckButtonWidgetGtk::Enable(void)
{
    gtk_widget_set_sensitive(GTK_WIDGET(_CheckButtonWidget), TRUE);
}

void TKinokoCheckButtonWidgetGtk::Disable(void)
{
    gtk_widget_set_sensitive(GTK_WIDGET(_CheckButtonWidget), FALSE);
}



TKinokoRadioButtonWidgetGtk::TKinokoRadioButtonWidgetGtk(const string& Name, GtkWidget* RadioButtonWidget)
: TKinokoRadioButtonWidget(Name)
{
    _RadioButtonWidget = RadioButtonWidget;
}

TKinokoRadioButtonWidgetGtk::~TKinokoRadioButtonWidgetGtk()
{
}

string TKinokoRadioButtonWidgetGtk::Value(void)
{
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(_RadioButtonWidget))) {
	return "1";
    }
    else {
	return "0";
    }
}

void TKinokoRadioButtonWidgetGtk::SetValue(const string& Value)
{
    gboolean State;
    if (Value.empty() || (Value == "0")) {
	State = FALSE;
    }
    else {
	State = TRUE;
    }

    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(_RadioButtonWidget), State);
}

void TKinokoRadioButtonWidgetGtk::Enable(void)
{
    gtk_widget_set_sensitive(GTK_WIDGET(_RadioButtonWidget), TRUE);
}

void TKinokoRadioButtonWidgetGtk::Disable(void)
{
    gtk_widget_set_sensitive(GTK_WIDGET(_RadioButtonWidget), FALSE);
}



TKinokoMenuItemWidgetGtk::TKinokoMenuItemWidgetGtk(const string& Name, GtkWidget* MenuItemWidget, const std::string& ActionOnClick)
: TKinokoMenuItemWidget(Name, ActionOnClick)
{
    _MenuItemWidget = MenuItemWidget;
}

TKinokoMenuItemWidgetGtk::~TKinokoMenuItemWidgetGtk()
{
}

void TKinokoMenuItemWidgetGtk::Enable(void)
{
    gtk_widget_set_sensitive(GTK_WIDGET(_MenuItemWidget), TRUE);
}

void TKinokoMenuItemWidgetGtk::Disable(void)
{
    gtk_widget_set_sensitive(GTK_WIDGET(_MenuItemWidget), FALSE);
}
