/* KinokoShellFileSelectDialogGtk.cc */
/* Created by Enomoto Sanshiro on 29 July 2000. */
/* Last updated by Enomoto Sanshiro on 29 July 2000. */


#include <gtk/gtk.h>
#include "MushFileSystem.hh"
#include "KinokoShellFileSelectDialog.hh"
#include "KinokoShellFileSelectDialogGtk.hh"

using namespace std;


static void ok_clicked_cb(GtkWidget* Widget, gpointer Data);
static void cancel_clicked_cb(GtkWidget* Widget, gpointer Data);
static void dialog_destroy_cb(GtkWidget* Widget, gpointer Data);

static string g_InitialFileName;
static string g_FileName;


TKinokoShellFileSelectDialogGtk::TKinokoShellFileSelectDialogGtk(const string& Title)
: TKinokoShellFileSelectDialog(Title)
{
}

TKinokoShellFileSelectDialogGtk::~TKinokoShellFileSelectDialogGtk()
{
}

string TKinokoShellFileSelectDialogGtk::Open(const string& InitialFileName)
{
    g_InitialFileName = InitialFileName;

    GtkWidget* Dialog = gtk_file_selection_new(_Title.c_str());

    gtk_signal_connect(
	GTK_OBJECT(GTK_FILE_SELECTION(Dialog)->ok_button),"clicked", 
	(GtkSignalFunc) ok_clicked_cb, Dialog
    );
    gtk_signal_connect(
	GTK_OBJECT(GTK_FILE_SELECTION(Dialog)->cancel_button),"clicked", 
	(GtkSignalFunc) cancel_clicked_cb, Dialog
    );
    gtk_signal_connect(
	GTK_OBJECT(Dialog), "destroy",
	(GtkSignalFunc) dialog_destroy_cb, 0
    );

    gtk_file_selection_set_filename(
	GTK_FILE_SELECTION(Dialog), g_InitialFileName.c_str()
    );

    gtk_widget_show(Dialog);    
    gtk_grab_add(GTK_WIDGET(Dialog));
    gtk_main();

    return g_FileName;
}


static void ok_clicked_cb(GtkWidget* Widget, gpointer Data)
{
    GtkWidget* Dialog = GTK_WIDGET(Data);
    g_FileName = gtk_file_selection_get_filename(GTK_FILE_SELECTION(Data));

    TMushFileAttribute FileAttribute(g_FileName);
    string PathName = FileAttribute.PathName();
    if (! PathName.empty()) {
	if (PathName == TMushFileSystem::CurrentDirectory() + "/") {
	    g_FileName = FileAttribute.FileName();
	}
    }

    gtk_widget_destroy(Dialog);
    gtk_main_quit();
}

static void cancel_clicked_cb(GtkWidget* Widget, gpointer Data)
{
    GtkWidget* Dialog = GTK_WIDGET(Data);
    g_FileName = g_InitialFileName;

    gtk_widget_destroy(Dialog);
    gtk_main_quit();
}

static void dialog_destroy_cb(GtkWidget* Widget, gpointer Data)
{
    gtk_grab_remove(GTK_WIDGET(Widget));
    gtk_main_quit();
}
