/* kcmlcheck.cc */
/* Created by Enomoto Sanshiro on 31 October 2001. */
/* Last updated by Enomoto Sanshiro on 31 October 2001. */


#include <iostream>
#include <string>
#include "MushArgumentList.hh"
#include "KinokoShellConnector.hh"
#include "KinokoControlGtk.hh"

using namespace std;


int main(int argc, char** argv)
{
    string ScriptFileName;

    TMushArgumentList ArgumentList(argc, argv);
    try {
	ArgumentList.ExpectParameters(1);
	ScriptFileName = ArgumentList.ParameterOf(0);
    }
    catch (TSystemCallException& e) {
	cerr << "Usage: " << argv[0] << " SCRIPT_FILE_NAME" << endl;
	return 0;
    }

    TKinokoShellConnector* ShellConnector = new TKinokoConsoleShellConnector();
    ShellConnector->Connect();

    TKinokoControl* Control = new TKinokoControlGtk(ShellConnector, argc, argv);

    Control->Construct(ScriptFileName);
    Control->Start();

    delete Control;

    return 0;
}
