/* kinoko-control-gtk.cc */
/* Created by Enomoto Sanshiro on 27 September 2001. */
/* Last updated by Enomoto Sanshiro on 27 September 2001. */


#include <iostream>
#include <string>
#include "MushArgumentList.hh"
#include "KinokoShellConnector.hh"
#include "KinokoControlGtk.hh"

using namespace std;


int main(int argc, char** argv)
{
    string HostName;
    int PortNumber;
    bool IsClient;

    TMushArgumentList ArgumentList(argc, argv);
    try {
	ArgumentList.ExpectParameters(2);
	HostName = ArgumentList.ParameterOf(0);
	PortNumber = ArgumentList.IntParameterOf(1);
	IsClient = ArgumentList.IsOptionSpecified("--client");
    }
    catch (TSystemCallException& e) {
	cerr << "Usage: " << argv[0] << " HOSTNAME PORT_NUMBER" << endl;
	return 0;
    }

    TKinokoShellConnector* ShellConnector;
    if (IsClient) {
	ShellConnector = new TKinokoClientSocketShellConnector(HostName, PortNumber);
    }
    else {
	ShellConnector = new TKinokoSocketShellConnector(HostName, PortNumber);
    }

    int FileDescriptor = ShellConnector->Connect();
    if (FileDescriptor < 0) {
	cerr << "unable to connect to " << HostName << endl;
	return -1;
    }

    TKinokoControl* Control = new TKinokoControlGtk(ShellConnector, argc, argv);
    Control->Start();

    delete Control;
    delete ShellConnector;

    return 0;
}
