#! /usr/bin/perl
# genscript-gnuplot-hist.pl
# Created by Sanshiro Enomoto on 23 June 2000.
# Last updated by Sanshiro Enomoto on 7 May 2001.


($script_file, $data_file) = @ARGV;
($data_file ne "") or die "Usage: genscript-gnuplot-hist SCRIPT_FILE DATA_FILE\n";


@data_path_list = split(/\//, $data_file);
$data_file_name = @data_path_list[$#data_path_list];

@script_path_list = split(/\//, $script_file);
$script_file_name = @script_path_list[$#script_path_list];
($data_name = $script_file_name) =~ s/\.\w+$//;


open (DATA_FILE, $data_file) or die "unable to open $data_file\n";
while (<DATA_FILE>) {
    chop($_);
    if (/^#\s*Fields\s*:\s*(.*)/) {
	@field_list = split(/\s+/, $1);
	last;
    }
}
close DATA_FILE;


$data_file =~ s/\.dat/_hist\.dat/;

($script = <<EOF)
    :# $script_file
    :# GNUPLOT script for '$data_file'.
    :# Generated automatically from $data_file by 'genscript-gnuplot-hist'.
    :
    :set terminal postscript landscape
    :set output \"$data_name.ps\"
    :
    :set title \"$data_name\"
    :%PLOT_COMMAND%
    :
    :set terminal X11
    :replot
    :
EOF
    =~ s/[ \t]*://sg;

$index = 1;
$plot_command = "plot \\\n";
$options = "with fsteps";
foreach $field_name (@field_list) {
    if ($field_name =~ /[Ii]ndex/) {
        next;
    }

    $index++;
    $plot_command .= "  \"$data_file\" ";
    $plot_command .= "using 1:$index ";
    $plot_command .= "title \"$field_name\" ";
    $plot_command .= "$options,\\\n";
}
$plot_command =~ s/,\\\n$/\n/s;

$script =~ s/[ \t]*%PLOT_COMMAND%[ \t]*\n/$plot_command/;

open(SCRIPT_FILE, "> $script_file") or die "unable to create $script_file.";
print SCRIPT_FILE $script;
close SCRIPT_FILE;
