#! /usr/bin/perl
# genscript-root-hist.pl
# Created by Sanshiro Enomoto on 23 June 2000.
# Last updated by Sanshiro Enomoto on 7 May 2001.


($script_file, $data_file, $hist_min, $hist_max, $hist_nbin) = @ARGV;
($hist_nbin ne "") or die "Usage: genscript-root-hist SCRIPT_FILE DATA_FILE HIST_MIN HIST_MAX HIST_NBIN\n";


@data_path_list = split(/\//, $data_file);
$data_file_name = @data_path_list[$#data_path_list];

@script_path_list = split(/\//, $script_file);
$script_file_name = @script_path_list[$#script_path_list];
($data_name = $script_file_name) =~ s/\.\w+$//;


open (DATA_FILE, $data_file) or die "unable to open $data_file\n";
while (<DATA_FILE>) {
    chop($_);
    if (/^#\s*Fields\s*:\s*(.*)/) {
	@field_list = split(/\s+/, $1);
	last;
    }
}
close DATA_FILE;


($script = <<EOF)
    :// $script_file
    :// ROOT script for '$data_file_name'.
    :// Generated automatically from $data_file by 'genscript-root-hist'.
    :
    :
    :#include <strstream.h>
    :#include <fstream.h>
    :
    :
    :int $data_name()
    :{
    :    gROOT->Reset();
    :    gROOT->SetStyle("Plain");
    :    TFile* file = new TFile("$data_name.root", "RECREATE");
    :
    :    ifstream is("$data_file");
    :    if (! is) {
    :        return -1;
    :    }
    :
    :    TCanvas* canvas = new TCanvas("canvas", "canvas", 0, 0, 800, 600);
    :
    :    %CREATE_HISTS%
    :
    :    char buffer[256];
    :    %DECLARE_FIELDS%
    :    while (is.getline(buffer, sizeof(buffer), '\\n')) {
    :        if (buffer[0] == '#') {
    :            continue;
    :        }
    :
    :        if (%READ_DATA%) {
    :            %FILL_HISTS%
    :        }
    :    }
    :
    :    %DRAW_HISTS%
    :
    :    file->Write();
    :    canvas->Print("$data_name.ps");
    :
    :    return 0;
    :}
EOF
    =~ s/[ \t]*://sg;

$create_hists = "";
$declare_fields = "    float index;\n";
$read_data = "istrstream(buffer) >> index";
$fill_hists = "";
$draw_hists = "    canvas->Divide(%ROWS%, %COLS%);\n";

$index = 0;
foreach $field_name (@field_list) {
    if ($field_name =~ /[Ii]ndex/) {
        next;
    }

    $index++;

    $create_hists 
        .= "    TH1F* hist$index = new TH1F("
	.  "\"$field_name\", \"$field_name\", "
	.  "$hist_nbin, $hist_min, $hist_max"
	.  ");\n";
    $declare_fields =~ s/;/, data$index;/;
    $read_data .= " >> data$index";
    $fill_hists .= "            hist$index->Fill(data$index);\n";
    $draw_hists .= "    canvas->cd($index);\n";
    $draw_hists .= "    hist$index->Draw();\n";
}

$script =~ s/[ \t]*%CREATE_HISTS%[ \t]*\n/$create_hists/;
$script =~ s/[ \t]*%DECLARE_FIELDS%[ \t]*\n/$declare_fields/;
$script =~ s/%READ_DATA%/$read_data/;
$script =~ s/[ \t]*%FILL_HISTS%[ \t]*\n/$fill_hists/;
$script =~ s/[ \t]*%DRAW_HISTS%[ \t]*\n/$draw_hists/;

if ($index <= 12) {
    $rows = (1, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4)[$index - 1];
    $cols = (1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3)[$index - 1];
}
else {
    $rows = int sqrt($index - 1) + 1;
    $cols = ($index - 1) / $rows + 1;
}
$script =~ s/%ROWS%/$rows/;
$script =~ s/%COLS%/$cols/;

open(SCRIPT_FILE, "> $script_file") or die "unable to create $script_file.";
print SCRIPT_FILE $script;
close SCRIPT_FILE;

