/* kdump.c */

#include <stdio.h>
#include <string.h>
#include <ctype.h>


void Dump(FILE* File, unsigned long Offset) 
{
    int Byte;
    unsigned long Address = Offset;
    char String[32] = "";
    String[16] = '\0';

    while ((Byte = getc(File)) != EOF) {
	if (Address % 16 == 0) {
	    printf("%04x %04x:  ", Address >> 16, Address & 0x0000ffff);
	}
	else if (Address % 8 == 0) {
	    printf("  ");
	}

	printf("%02x ", Byte);
	String[Address % 16] = isprint(Byte) ? Byte : '.';
	Address++;

	if (Address % 16 == 0) {
	    printf("  %s\n", String);
	}
    }

    putchar('\n');
}


int main(int argc, char** argv)
{
    char* FileName = NULL;
    FILE* File = NULL;
    unsigned long Offset = 0;

    if ((argc > 1) && (strcmp(argv[1], "--help") == 0)) {
	printf("usage: %s [FileName [Offset(hex)]]\n", argv[0]);
	return 0;
    }

    if (argc > 1) {
	FileName = argv[1];
	if ((File = fopen(FileName, "r")) == NULL) {
	    fprintf(stderr, "unable to open file: %s\n", FileName);
	    return -1;
	}

	if (argc > 2) {
	    if (sscanf(argv[2], "%lx", &Offset) != 1) {
		fprintf(stderr, "bad file offset: %s\n", argv[2]);
		fclose(File);
		return -1;
	    }

	    Offset &= ~0x000fUL;

	    if (fseek(File, Offset, SEEK_SET) < 0) {
		fprintf(stderr, "invalid file offset: %s\n", argv[2]);
		fclose(File);
		return -1;
	    }
	}
    }
    else {
	File = stdin;
    }

    Dump(File, Offset);

    if (FileName != NULL) {
	fclose(File);
    }

    return 0;
}
