#! /usr/bin/perl
# makehist.pl
# Created by Sanshiro Enomoto on 30 June 2000.
# Last updated by Sanshiro Enomoto on 1 July 2000.


($data_file, $hist_min, $hist_max, $hist_nbin) = @ARGV;
($hist_nbin != 0) or die "Usage: makehist DATA_FILE MIN MAX NBIN\n";

open(DATA_FILE, "$data_file") or die "Unable to open file: $data_file\n";

$hist_range = $hist_max - $hist_min;
$hist_step = $hist_range / $hist_nbin;

while (<DATA_FILE>) {
    if (/(^\s*\#|^\s$)/) {
	print;
	next;
    }

    chop($_);
    @record = split(/[,\s]\s*/, $_);

    for ($field_index = 1; $field_index < @record; $field_index++) {
        $value = $record[$field_index];
        $class = int (($value - $hist_min) / $hist_range * $hist_nbin);

	$counts[$field_index][$class] += 1;
    }
}

for ($class = 0; $class < $hist_nbin; $class++) {
    $class_value = $hist_min + ($class + 1) * $hist_step;
    print "$class_value    ";

    for ($field_index = 1; $field_index < @record; $field_index++) {
        $count = 0 + $counts[$field_index][$class];
	print "$count    ";
    }
    print "\n";
}
