/* shmrm.c */

#include <stdio.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>



int main(int argc, char** argv)
{
    char* ProjectPath;
    int ProjectId;
    key_t IpcKey;
    int IpcId;
    struct shmid_ds StatusBuffer;

    if (
	(argc < 3) ||
	(sscanf(argv[2], "%d", &ProjectId) != 1)
    ){
	fprintf(stderr, "usage: %s ProjectPath ProjectId\n", argv[0]);
	return -1;
    }
    ProjectPath = argv[1];

    if ((IpcKey = ftok(ProjectPath, ProjectId)) < 0) {
	fprintf(stderr, "unable to find IPC key: no msg removed\n");
	return 0;
    }

    IpcId = shmget(IpcKey, 0, 0);
    if (IpcId < 0) {
	fprintf(stderr, "no msq found: no msg removed\n");
	return 0;
    }

    shmctl(IpcId, IPC_RMID, &StatusBuffer);

    return 0;
}
