/* VmeAdc.kts */
/* Created by Enomoto Sanshiro on 27 April 2005 */
/* Last updated by Enomoto Sanshiro on 27 April 2005 */


datasource VmeAdc
{
    int base_address = 0x07920000;
    int readout_channels = #0..#3 | #16;

    VmeCrate crate;
    VmeController controller("SBS-620");
    VmeModule adc("CAEN-V792N");
    
    crate.installController(controller);
    crate.installModule(adc, base_address);

    on run_begin {
	adc.disable(~readout_channels);
        adc.disableZeroSuppression();
        adc.disableOverflowSuppression();

        //adc.setThreshold(0, 200);
	//adc.setEventTrigger(16);
    };

    Register event_counter;
    DataRecord event_info;

    on trigger(adc) {
        adc.read(readout_channels);
	//adc.blockRead();

        adc.readEventCounter(event_counter);
	event_info.fill("event_count", event_counter);
	event_info.send();
    }
}
