/* SimCamacAdc.kts */
/* Created by Enomoto Sanshiro on 9 May 2001 */
/* Last updated by Enomoto Sanshiro on 9 May 2001. */


datasource CamacAdc
{
    int readout_channels = #0..#15;

    SoftwareModule adc("PmtSimulator");
    SoftwareModule timer("IntervalTimer");

    DataRecord event_info;
    Register event_number;
    Register event_time;

    on run_begin {
        timer.setInterval(0, 100000);
    }

    on trigger(timer) {
	adc.read(readout_channels);
	adc.clear();
	
	event_number.add(1);
	readTime(event_time);
	event_info.fill("event_number", event_number);
	event_info.fill("event_time", event_time);
	event_info.send();
    }
}
