/* VmeScaler.kts */
/* Created by Enomoto Sanshiro on 8 October 2008. */
/* Last updated by Enomoto Sanshiro on 8 October 2008. */

datasource VmeScaler
{
    int base_address = 0x00100000;
    int readout_channels = #0..#3;
    
    VmeCrate crate;
    VmeController controller("SBS-620");
    VmeModule scaler("Hoshin-V004");
    SoftwareModule timer("IntervalTimer");
    
    crate.installController(controller);
    crate.installModule(scaler, base_address);

    on run_begin {
	timer.setInterval(1, 0);
	scaler.enable(readout_channels);
    }

    on trigger(timer) {
	scaler.read(readout_channels);
    }
}

