/* KinokoAlarmClockCom.cc */
/* Created by Enomoto Sanshiro on 20 May 2001. */
/* Last updated by Enomoto Sanshiro on 20 May 2001. */


#include <sstream>
#include "MushMisc.hh"
#include "KinokoSystemComponent.hh"
#include "KinokoAlarmClockCom.hh"

using namespace std;


TKinokoAlarmClockCom::TKinokoAlarmClockCom(void)
: TKinokoSystemComponent("KinokoAlarmClockCom")
{
    _IsRunning = false;
    _Interval = 0;
    _StartTime = 0;
}

TKinokoAlarmClockCom::~TKinokoAlarmClockCom()
{
}

void TKinokoAlarmClockCom::BuildDescriptor(TKcomComponentDescriptor& Descriptor)
{
    TKinokoSystemComponent::BuildDescriptor(Descriptor);

    TKcomEventDeclaration SetIntervalEvent("setInterval");
    SetIntervalEvent.AddArgument(TKcomPropertyDeclaration(
        "interval_sec", TKcomPropertyDeclaration::Type_Int
    ));
    Descriptor.RegisterEventSlot(EventId_SetInterval, SetIntervalEvent);

    TKcomEventDeclaration StartEvent("start");
    Descriptor.RegisterEventSlot(EventId_Start, StartEvent);

    TKcomEventDeclaration StartOneShotEvent("startOneShot");
    Descriptor.RegisterEventSlot(EventId_StartOneShot, StartOneShotEvent);

    TKcomEventDeclaration StopEvent("stop");
    Descriptor.RegisterEventSlot(EventId_Stop, StopEvent);

    TKcomEventDeclaration RingEvent("ring");
    Descriptor.RegisterEventSource(EventId_Ring, RingEvent);
}

int TKinokoAlarmClockCom::ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse)
{
    int Result = 0;

    switch (EventId) {
      case EventId_SetInterval:
	Result = ProcessSetIntervalEvent(Event);
	break;

      case EventId_Start:
	Result = ProcessStartEvent(Event);
	break;

      case EventId_StartOneShot:
	Result = ProcessStartOneShotEvent(Event);
	break;

      case EventId_Stop:
	Result = ProcessStopEvent(Event);
	break;

      default:
	Result = TKinokoSystemComponent::ProcessEvent(
	    EventId, Event, EventResponse
	);
    }

    return Result;
}

int TKinokoAlarmClockCom::DoTransaction(void) throw(TKcomException)
{
    if (_IsRunning && (_Interval > 0)) {
	long CurrentTime = TMushDateTime().AsLong();
	if ((CurrentTime - _StartTime) > _Interval) {
	    _StartTime = CurrentTime;
	    if (_IsOneShot) {
		_IsRunning = false;
	    }

	    EmitRingEvent();
	}
    }

    return TKinokoSystemComponent::DoTransaction();
}

int TKinokoAlarmClockCom::ProcessSetIntervalEvent(TKcomEvent& Event)
{
    int Result = 0;
    if (Event.ArgumentList().size() < 1) {
	// error
	return 0;
    }

    istringstream IntervalStream(Event.ArgumentList()[0]);
    if (IntervalStream >> _Interval) {
	Result = 1;
    }

    return Result;
}

int TKinokoAlarmClockCom::ProcessStartEvent(TKcomEvent& Event)
{
    _StartTime = TMushDateTime().AsLong();
    _IsRunning = true;
    _IsOneShot = false;

    return 1;
}

int TKinokoAlarmClockCom::ProcessStartOneShotEvent(TKcomEvent& Event)
{
    _StartTime = TMushDateTime().AsLong();
    _IsRunning = true;
    _IsOneShot = true;

    return 1;
}

int TKinokoAlarmClockCom::ProcessStopEvent(TKcomEvent& Event)
{
    _IsRunning = false;

    return 1;
}

void TKinokoAlarmClockCom::EmitRingEvent(void)
{
    TKcomEvent Event;
    EmitEventOneWay(EventId_Ring, Event);
}
