/* KinokoAlarmClockCom.hh */
/* Created by Enomoto Sanshiro on 20 May 2001. */
/* Last updated by Enomoto Sanshiro on 20 May 2001. */


#ifndef __KinokoAlarmClockCom_hh__
#define __KinokoAlarmClockCom_hh__


#include "KinokoSystemComponent.hh"


class TKinokoAlarmClockCom: public TKinokoSystemComponent {
  public:
    TKinokoAlarmClockCom(void);
    virtual ~TKinokoAlarmClockCom();
    virtual void BuildDescriptor(TKcomComponentDescriptor& Descriptor);
    virtual int ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse);
    virtual int DoTransaction(void) throw(TKcomException);
  protected:
    int ProcessSetIntervalEvent(TKcomEvent& Event);
    int ProcessStartEvent(TKcomEvent& Event);
    int ProcessStartOneShotEvent(TKcomEvent& Event);
    int ProcessStopEvent(TKcomEvent& Event);
    void EmitRingEvent(void);
  protected:
    enum TEventId {
	EventId_SetInterval = TKinokoSystemComponent::_NumberOfEvents,
	EventId_Start,
	EventId_StartOneShot,
	EventId_Stop,
	EventId_Ring,
	_NumberOfEvents
    };
  protected:
    bool _IsRunning, _IsOneShot;
    long _StartTime, _Interval;
};


#endif
