/* DataAnalyzer02.cc */


#include <cstdlib>
#include <iostream>
#include <string>
#include "KinokoKdfReader.hh"
#include "KinokoSectionDataAnalyzer.hh"

using namespace std;



class TMyDataAnalyzer: public TKinokoSectionDataAnalyzer {
  public:
    TMyDataAnalyzer(void);
    virtual ~TMyDataAnalyzer();
    virtual int ProcessData(TKinokoSectionData* SectionData) throw(TKinokoException);
    virtual int ProcessTrailer(int TrailerValue) throw(TKinokoException);
  protected:
    int _AdcSectionIndex, _TdcSectionIndex;
};



TMyDataAnalyzer::TMyDataAnalyzer(void)
{
    _AdcSectionIndex = AddSection("adc");
    _TdcSectionIndex = AddSection("tdc");
}

TMyDataAnalyzer::~TMyDataAnalyzer()
{
}

int TMyDataAnalyzer::ProcessData(TKinokoSectionData* SectionData) throw(TKinokoException)
{
    const char* SectionName = "unknown";
    if (SectionData->SectionIndex() == _AdcSectionIndex) {
	SectionName = "adc";
    }
    else if (SectionData->SectionIndex() == _TdcSectionIndex) {
	SectionName = "tdc";
    }

    // an alternative way to get the section name ...
    //string SectionName = SectionData->SectionName();

    int Address, Data;
    while (SectionData->GetNext(Address, Data)) {
	cout << SectionName << " " << Address << " " << Data << endl;
    }

    return 1;
}

int TMyDataAnalyzer::ProcessTrailer(int TrailerValue) throw(TKinokoException)
{
    if (TrailerValue == TKinokoDataStreamScanner::Trailer_Event) {
	cout << endl;
    }

    return 1;
}



int main(int argc, char** argv)
{
    if (argc < 2) {
	cerr << "Usage: " << argv[0] << " DataFileName" << endl;
        return EXIT_FAILURE;
    }
    string DataFileName = argv[1];
    string DataSourceName = "";

    TKinokoKdfReader* KdfReader = new TKinokoKdfReader(DataFileName);
    TKinokoDataAnalyzer* Analyzer = new TMyDataAnalyzer();
    
    try {
	KdfReader->RegisterAnalyzer(DataSourceName, Analyzer);
	KdfReader->Start();
    }
    catch (TKinokoException& e) {
	cerr << "ERROR: " << e << endl;
        return EXIT_FAILURE;
    }

    delete Analyzer;
    delete KdfReader;

    return 0;
}
