/* DataAnalyzer03.cc */


#include <cstdlib>
#include <iostream>
#include <iomanip>
#include <string>
#include "KinokoKdfReader.hh"
#include "KinokoSectionDataAnalyzer.hh"

using namespace std;


class TMyDataAnalyzer: public TKinokoSectionDataAnalyzer {
  public:
    TMyDataAnalyzer(void);
    virtual ~TMyDataAnalyzer();
    virtual int ProcessData(TKinokoSectionData* SectionData) throw(TKinokoException);
    virtual int ProcessTrailer(int TrailerValue) throw(TKinokoException);
};



TMyDataAnalyzer::TMyDataAnalyzer(void)
: TKinokoSectionDataAnalyzer("adc")
{
}

TMyDataAnalyzer::~TMyDataAnalyzer()
{
}

int TMyDataAnalyzer::ProcessData(TKinokoSectionData* SectionData) throw(TKinokoException)
{
    void* DataBlock = SectionData->GetDataBlock();
    size_t DataBlockSize = SectionData->DataBlockSize();

    // hexadecimal dump //
    cout << "[" << SectionData->SectionName() << "]";
    cout << hex << setfill('0');
    for (unsigned Offset = 0; Offset < DataBlockSize; Offset++) {
	if (Offset % 16 == 0) {
	    cout << endl;
	    cout << setw(4) << Offset << ":  ";
	}
	else if (Offset % 8 == 0) {
	    cout << " ";
	}	
	cout << setw(2) << (int) ((unsigned char*) DataBlock)[Offset] << " ";
    }
    cout << dec << setfill(' ') << endl;

    return 1;
}

int TMyDataAnalyzer::ProcessTrailer(int TrailerValue) throw(TKinokoException)
{
    if (TrailerValue == TKinokoDataStreamScanner::Trailer_Event) {
	cout << endl;
    }

    return 1;
}



int main(int argc, char** argv)
{
    if (argc < 2) {
	cerr << "Usage: " << argv[0] << " DataFileName" << endl;
        return EXIT_FAILURE;
    }
    string DataFileName = argv[1];
    string DataSourceName = "";

    TKinokoKdfReader* KdfReader = new TKinokoKdfReader(DataFileName);
    TKinokoDataAnalyzer* Analyzer = new TMyDataAnalyzer();
    
    try {
	KdfReader->RegisterAnalyzer(DataSourceName, Analyzer);
	KdfReader->Start();
    }
    catch (TKinokoException& e) {
	cerr << "ERROR: " << e << endl;
        return EXIT_FAILURE;
    }

    delete Analyzer;
    delete KdfReader;

    return 0;
}
